/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SludgeBlock
extends HalfTransparentBlock {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    private static final BooleanProperty DISSOLVING = BooleanProperty.create((String)"dissolving");

    public SludgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DISSOLVING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISSOLVING});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (((Boolean)state.getValue((Property)DISSOLVING)).booleanValue()) {
            level.scheduleTick(pos, (Block)this, level.random.nextInt(10) + 20);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos).getBlock() == this && ((Boolean)state.getValue((Property)DISSOLVING)).booleanValue()) {
            level.removeBlock(pos, false);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getInBlockState().is((Block)this)) {
            entity.makeStuckInBlock(state, new Vec3((double)0.2f, (double)0.2f, (double)0.2f));
        }
        if (entity instanceof LivingEntity && !level.isClientSide && BlockPos.containing((Position)entity.getEyePosition()).equals((Object)pos) && level.getGameTime() % 20L == 0L) {
            entity.hurt(level.damageSources().inWall(), 1.0f);
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext collisionContext;
        if (context instanceof EntityCollisionContext && (collisionContext = (EntityCollisionContext)context).getEntity() instanceof FallingBlockEntity) {
            return super.getCollisionShape(state, level, pos, context);
        }
        return Shapes.empty();
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }
}

