/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class RecipeUnlocker {
    private static String modtag;
    private static int version;
    private static String MODID;

    public static void register(String modid, IEventBus bus, int recipeversion) {
        modtag = modid + "_unlocked";
        version = recipeversion;
        MODID = modid;
        bus.addListener(RecipeUnlocker::onPlayerLoggedIn);
    }

    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server;
        Player player = event.getEntity();
        CompoundTag tag = player.getPersistentData();
        if (tag.contains(modtag) && tag.getInt(modtag) >= version) {
            return;
        }
        if (player instanceof ServerPlayer && (server = player.getServer()) != null) {
            ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(server.getRecipeManager().getRecipes());
            recipes.removeIf(recipe -> !recipe.id().getNamespace().contains(MODID));
            player.awardRecipes(recipes);
            tag.putInt(modtag, version);
        }
    }
}

