/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class ItemUtil {
    public static Item getItemFromName(String name) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)name));
    }

    @Deprecated
    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean checkWildcard) {
        return ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2);
    }

    @Deprecated
    public static void addEnchantment(ItemStack stack, Holder<Enchantment> e, int level, RegistryAccess lookup) {
        if (stack.getAllEnchantments(lookup.lookupOrThrow(Registries.ENCHANTMENT)).getLevel(e) <= 0) {
            stack.enchant(e, level);
        }
    }

    public static void removeEnchantment(ItemStack stack, Holder<Enchantment> e, RegistryAccess registryAccess) {
        ItemEnchantments enchantments = stack.getAllEnchantments(registryAccess.lookupOrThrow(Registries.ENCHANTMENT));
        ItemEnchantments.Mutable itemenchantments$mutable = new ItemEnchantments.Mutable(enchantments);
        itemenchantments$mutable.removeIf(enchantment -> enchantment == e);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)itemenchantments$mutable.toImmutable());
    }

    public static boolean canBeStacked(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ActuallyComponents.ENABLED, (Object)false);
    }

    public static void changeEnabled(Player player, InteractionHand hand) {
        ItemUtil.changeEnabled(player.getItemInHand(hand));
    }

    public static void changeEnabled(ItemStack stack) {
        boolean isEnabled = ItemUtil.isEnabled(stack);
        stack.set(ActuallyComponents.ENABLED, (Object)(!isEnabled ? 1 : 0));
    }
}

