/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerDirectionalBreaker;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityLongRangeBreaker
extends TileEntityInventoryBase
implements MenuProvider {
    public static final int RANGE = 8;
    public static final int ENERGY_USE = 5;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(10000, 20, 0);
    private int lastEnergy;
    private int currentTime;

    public TileEntityLongRangeBreaker(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.LONG_RANGE_BREAKER.getTileEntityType(), pos, state, 9);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.getInt("CurrentTime");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLongRangeBreaker) {
            TileEntityLongRangeBreaker tile = (TileEntityLongRangeBreaker)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityLongRangeBreaker) {
            TileEntityLongRangeBreaker tile = (TileEntityLongRangeBreaker)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.currentTime > 0) {
                    --tile.currentTime;
                    if (tile.currentTime <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.currentTime = 15;
                }
            }
            if (tile.storage.getEnergyStored() != tile.lastEnergy && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 40) {
            BlockState state = this.getBlockState();
            Direction sideToManipulate = WorldUtil.getDirectionByPistonRotation(state);
            for (int i = 0; i < 8; ++i) {
                BlockPos coordsBlock = this.worldPosition.relative(sideToManipulate, i + 1);
                BlockState breakState = this.level.getBlockState(coordsBlock);
                Block blockToBreak = breakState.getBlock();
                if (blockToBreak == null || this.level.isEmptyBlock(coordsBlock) || !(this.level.getBlockState(coordsBlock).getDestroySpeed((BlockGetter)this.level, coordsBlock) > -1.0f)) continue;
                List drops = Block.getDrops((BlockState)breakState, (ServerLevel)((ServerLevel)this.level), (BlockPos)coordsBlock, (BlockEntity)this.level.getBlockEntity(coordsBlock));
                float chance = WorldUtil.fireFakeHarvestEventsForDropChance(this, this.level, coordsBlock);
                if (!(chance > 0.0f) || !(this.level.random.nextFloat() <= chance) || !StackUtil.canAddAll(this.inv, drops, false)) continue;
                this.level.levelEvent(2001, coordsBlock, Block.getId((BlockState)this.level.getBlockState(coordsBlock)));
                this.level.setBlockAndUpdate(coordsBlock, Blocks.AIR.defaultBlockState());
                StackUtil.addAll(this.inv, drops, false);
                this.storage.extractEnergyInternal(5, false);
                this.setChanged();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.directionalBreaker");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerDirectionalBreaker(windowId, playerInventory, this);
    }
}

