/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.particle.LaserItemParticleData;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ParticleLaserItem
extends Particle {
    private final double otherX;
    private final double otherY;
    private final double otherZ;
    private final ItemStack stack;

    private ParticleLaserItem(ClientLevel world, double posX, double posY, double posZ, ItemStack stack, double motionY) {
        this(world, posX, posY, posZ, stack, motionY, 0.0, 0.0, 0.0);
    }

    public ParticleLaserItem(ClientLevel world, double posX, double posY, double posZ, ItemStack stack, double motionY, double otherX, double otherY, double otherZ) {
        super(world, posX + (world.random.nextDouble() - 0.5) / 8.0, posY, posZ + (world.random.nextDouble() - 0.5) / 8.0);
        this.stack = stack;
        this.otherX = otherX;
        this.otherY = otherY;
        this.otherZ = otherZ;
        this.xd = 0.0;
        this.yd = motionY;
        this.zd = 0.0;
        this.lifetime = 10;
        this.hasPhysics = false;
    }

    public void remove() {
        super.remove();
        if (this.otherX != 0.0 || this.otherY != 0.0 || this.otherZ != 0.0) {
            this.level.addParticle(Factory.createData(this.stack, 0.0, 0.0, 0.0), this.otherX, this.otherY, this.otherZ, 0.0, -0.025, 0.0);
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource renderBuffer = mc.renderBuffers().bufferSource();
        Vec3 cam = renderInfo.getPosition();
        PoseStack matrices = new PoseStack();
        matrices.pushPose();
        matrices.translate(this.x - cam.x, this.y - cam.y, this.z - cam.z);
        matrices.scale(0.3f, 0.3f, 0.3f);
        double boop = (double)Util.getMillis() / 600.0;
        matrices.mulPose(Axis.YP.rotationDegrees((float)(boop * 40.0 % 360.0)));
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float ageRatio = (float)this.age / (float)this.lifetime;
        float color = this.yd < 0.0 ? 1.0f - ageRatio : ageRatio;
        int blockLight = this.level.getBrightness(LightLayer.BLOCK, BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
        int skyLight = this.level.getBrightness(LightLayer.SKY, BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
        AssetUtil.renderItemWithoutScrewingWithColors(this.stack, matrices, LightTexture.pack((int)blockLight, (int)skyLight), OverlayTexture.NO_OVERLAY);
        matrices.popPose();
        renderBuffer.endBatch();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<LaserItemParticleData> {
        public Factory(SpriteSet sprite) {
        }

        public Particle createParticle(LaserItemParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleLaserItem(worldIn, x, y, z, data.stack(), ySpeed, data.outputX(), data.outputY(), data.outputZ());
        }

        public static ParticleOptions createData(ItemStack stack, double outputX, double outputY, double outputZ) {
            return new LaserItemParticleData(stack, outputX, outputY, outputZ);
        }
    }
}

