/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network.handler;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.IStringReactor;
import de.ellpeck.actuallyadditions.mod.network.packet.ButtonToContainerPacket;
import de.ellpeck.actuallyadditions.mod.network.packet.ButtonToTilePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.NumberToTilePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.StringToTilePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.SyncPlayerPacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleButtonToTile(ButtonToTilePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            ServerLevel level;
            BlockEntity tile;
            if (context.player() != null && (tile = (level = (player = context.player()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packet.dimension()))).getBlockEntity(packet.pos())) instanceof IButtonReactor) {
                IButtonReactor reactor = (IButtonReactor)tile;
                Entity entity = level.getEntity(packet.playerId());
                if (entity instanceof Player) {
                    reactor.onButtonPressed(packet.buttonId(), (Player)entity);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.button_to_tile.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleStringToTile(StringToTilePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            ServerLevel level;
            BlockEntity tile;
            if (context.player() != null && (tile = (level = (player = context.player()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packet.dimension()))).getBlockEntity(packet.pos())) instanceof IStringReactor) {
                IStringReactor reactor = (IStringReactor)tile;
                reactor.onTextReceived(packet.text(), packet.textId(), (Player)level.getEntity(packet.playerId()));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.string_to_tile.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleNumberToTile(NumberToTilePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            ServerLevel level;
            BlockEntity tile;
            if (context.player() != null && (tile = (level = (player = context.player()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packet.dimension()))).getBlockEntity(packet.pos())) instanceof INumberReactor) {
                INumberReactor reactor = (INumberReactor)tile;
                reactor.onNumberReceived(packet.number(), packet.numberId(), (Player)level.getEntity(packet.playerId()));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.number_to_tile.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleButtonToContainer(ButtonToContainerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            ServerLevel level;
            Entity entity;
            if (context.player() != null && (entity = (level = (player = context.player()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packet.dimension()))).getEntity(packet.playerId())) instanceof Player) {
                Player p = (Player)entity;
                AbstractContainerMenu container = p.containerMenu;
                if (container instanceof IButtonReactor) {
                    IButtonReactor reactor = (IButtonReactor)container;
                    reactor.onButtonPressed(packet.buttonId(), (Player)entity);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.button_to_container.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSyncPlayer(SyncPlayerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                CompoundTag tag = packet.tag();
                ServerLevel level = context.player().getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)tag.getString("World"))));
                ServerPlayer player = level.getServer().getPlayerList().getPlayer(tag.getUUID("UUID"));
                if (player != null) {
                    PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((Player)player);
                    WorldData.get((Level)level).setDirty();
                    if (tag.getBoolean("Log")) {
                        ActuallyAdditions.LOGGER.info("Receiving changed Player Data for player {}.", (Object)player.getName());
                    }
                } else {
                    ActuallyAdditions.LOGGER.error("Tried to receive Player Data for UUID {}, but he doesn't seem to be present!", (Object)tag.getUUID("UUID"));
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"actuallyadditions.networking.sync_player.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

