/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.inventory.SackContainer;
import de.ellpeck.actuallyadditions.mod.inventory.VoidSackContainer;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.sack.SackData;
import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class Sack
extends ItemBase {
    public final boolean isVoid;

    public Sack(boolean isVoid) {
        super(ActuallyItems.defaultProps().stacksTo(1));
        this.isVoid = isVoid;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack sackStack = player.getItemInHand(hand);
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND && sackStack.getItem() instanceof Sack && player instanceof ServerPlayer) {
            if (!this.isVoid) {
                SackData data = Sack.getData(sackStack);
                if (data == null) {
                    return InteractionResultHolder.fail((Object)sackStack);
                }
                UUID uuid = data.getUuid();
                data.updateAccessRecords(player.getName().getString(), System.currentTimeMillis());
                boolean autoInsert = (Boolean)sackStack.getOrDefault(ActuallyComponents.AUTO_INSERT, (Object)false);
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new SackContainer(id, inv, data.getSpecialHandler(), autoInsert, data.getFilter()), sackStack.getHoverName()), buffer -> buffer.writeUUID(uuid).writeBoolean(autoInsert).writeInt(data.getFilter().getPackedSettings()));
            } else {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new VoidSackContainer(id, inv), sackStack.getHoverName()));
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public static SackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.getItem() instanceof Sack)) {
            return null;
        }
        if (stack.has(ActuallyComponents.UUID)) {
            uuid = (UUID)stack.get(ActuallyComponents.UUID);
        } else if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (tag.contains("UUID")) {
                uuid = tag.getUUID("UUID");
                stack.set(ActuallyComponents.UUID, (Object)uuid);
                stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, $ -> $.update(compoundTag -> compoundTag.remove("UUID")));
            } else {
                uuid = UUID.randomUUID();
                stack.set(ActuallyComponents.UUID, (Object)uuid);
            }
        } else {
            uuid = UUID.randomUUID();
            stack.set(ActuallyComponents.UUID, (Object)uuid);
        }
        return SackManager.get().getOrCreateSack(uuid);
    }
}

