/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemPlayerProbe
extends ItemBase {
    public ItemPlayerProbe() {
        super(ActuallyItems.defaultProps().stacksTo(1));
    }

    public void inventoryTick(@Nonnull ItemStack stack, Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        UUID uuid;
        if (!world.isClientSide && (uuid = (UUID)stack.get(ActuallyComponents.UUID)) != null) {
            Player player = world.getPlayerByUUID(uuid);
            if (player != null) {
                if (player.isShiftKeyDown()) {
                    ItemPhantomConnector.clearStorage(stack, ActuallyComponents.UUID.get(), ActuallyComponents.NAME.get());
                    ((Player)entity).displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.disconnect.1"), false);
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.notice"), false);
                }
            } else {
                ItemPhantomConnector.clearStorage(stack, ActuallyComponents.UUID.get(), ActuallyComponents.NAME.get());
                ((Player)entity).displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.disconnect.2"), false);
            }
        }
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(context.getHand());
        BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
        if (tile instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface face = (TileEntityPlayerInterface)tile;
            UUID uuid = (UUID)stack.get(ActuallyComponents.UUID);
            String name = (String)stack.get(ActuallyComponents.NAME);
            if (uuid != null) {
                if (!context.getLevel().isClientSide) {
                    face.connectedPlayer = uuid;
                    face.playerName = name;
                    face.setChanged();
                    face.sendUpdate();
                    ItemPhantomConnector.clearStorage(stack, ActuallyComponents.UUID.get(), ActuallyComponents.NAME.get());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack aStack, Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        Player playerHit;
        ItemStack stack;
        if (!player.level().isClientSide && !(stack = player.getMainHandItem()).isEmpty() && stack.getItem() == this && entity instanceof Player && !(playerHit = (Player)entity).isShiftKeyDown()) {
            stack.set(ActuallyComponents.UUID, (Object)playerHit.getUUID());
            stack.set(ActuallyComponents.NAME, (Object)playerHit.getName().getString());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, @Nonnull Item.TooltipContext pContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        String name = (String)stack.get(ActuallyComponents.NAME);
        if (name != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.probing").append(": " + name));
        }
    }
}

