/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemPhantomConnector
extends ItemBase {
    public ItemPhantomConnector() {
        super(ActuallyItems.defaultNonStacking());
    }

    public static ResourceKey<Level> getStoredWorld(ItemStack stack) {
        return (ResourceKey)stack.get(ActuallyComponents.LEVEL);
    }

    public static BlockPos getStoredPosition(ItemStack stack) {
        return (BlockPos)stack.get(ActuallyComponents.POSITION);
    }

    public static void clearStorage(ItemStack stack, DataComponentType<?> ... componentTypes) {
        for (DataComponentType<?> key : componentTypes) {
            stack.remove(key);
        }
    }

    public static void storeConnection(ItemStack stack, int x, int y, int z, Level world) {
        stack.set(ActuallyComponents.POSITION, (Object)new BlockPos(x, y, z));
        stack.set(ActuallyComponents.LEVEL, (Object)world.dimension());
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (!context.getLevel().isClientSide) {
            BlockPos pos = context.getClickedPos();
            BlockEntity tile = context.getLevel().getBlockEntity(pos);
            if (tile != null && tile instanceof IPhantomTile) {
                BlockPos stored = ItemPhantomConnector.getStoredPosition(stack);
                if (stored != null && ItemPhantomConnector.getStoredWorld(stack) == context.getLevel().dimension()) {
                    ((IPhantomTile)tile).setBoundPosition(stored);
                    if (tile instanceof TileEntityBase) {
                        ((TileEntityBase)tile).sendUpdate();
                    }
                    ItemPhantomConnector.clearStorage(stack, ActuallyComponents.POSITION.get(), ActuallyComponents.LEVEL.get());
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.phantom.connected.desc"), true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            ItemPhantomConnector.storeConnection(stack, pos.getX(), pos.getY(), pos.getZ(), context.getLevel());
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.phantom.stored.desc"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> list, TooltipFlag advanced) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add((Component)Component.translatable((String)"tooltip.actuallyadditions.boundTo.desc").append(":"));
            list.add((Component)Component.literal((String)("X: " + coords.getX())));
            list.add((Component)Component.literal((String)("Y: " + coords.getY())));
            list.add((Component)Component.literal((String)("Z: " + coords.getZ())));
            list.add((Component)Component.translatable((String)"tooltip.actuallyadditions.clearStorage.desc").withStyle(ChatFormatting.ITALIC));
        }
    }
}

