/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.gui;

import com.flanks255.pocketstorage.gui.PSUContainer;
import com.flanks255.pocketstorage.network.SlotClickPacket;
import com.flanks255.pocketstorage.network.SlotKeyPacket;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class PSUGui
extends AbstractContainerScreen<PSUContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"pocketstorage", (String)"textures/gui/psugui.png");
    private int scroll = 0;

    public PSUGui(PSUContainer container, Inventory inventory, Component name) {
        super((AbstractContainerMenu)container, inventory, name);
        this.imageWidth = 176;
        this.imageHeight = 180;
    }

    protected void init() {
        super.init();
        Button.OnPress slotClick = button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SlotClickPacket(((GUISlot)button).slot + this.scroll, Screen.hasShiftDown(), Screen.hasControlDown(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((PSUContainer)this.menu).networkSlotClick(((GUISlot)button).slot + this.scroll, Screen.hasShiftDown(), Screen.hasControlDown(), false);
        };
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8, this.topPos + 19, 34, 36, 0, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 36, this.topPos + 19, 34, 36, 1, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 72, this.topPos + 19, 34, 36, 2, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 108, this.topPos + 19, 34, 36, 3, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8, this.topPos + 19 + 38, 34, 36, 4, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 36, this.topPos + 19 + 38, 34, 36, 5, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 72, this.topPos + 19 + 38, 34, 36, 6, slotClick));
        this.addRenderableWidget((GuiEventListener)new GUISlot(this.leftPos + 8 + 108, this.topPos + 19 + 38, 34, 36, 7, slotClick));
        this.addRenderableWidget((GuiEventListener)new ScrollButton(this, this.leftPos + 152, this.topPos + 18, 16, 37, true, A -> {
            this.scroll = this.scroll <= 0 ? 0 : this.scroll - 4;
        }));
        this.addRenderableWidget((GuiEventListener)new ScrollButton(this, this.leftPos + 152, this.topPos + 55, 16, 37, false, A -> {
            this.scroll = this.scroll >= ((PSUContainer)this.menu).handler.getSlots() - 8 ? ((PSUContainer)this.menu).handler.getSlots() - 8 : this.scroll + 4;
        }));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0) {
            this.scroll = Mth.clamp((int)(this.scroll + 4), (int)0, (int)(((PSUContainer)this.menu).handler.getSlots() - 8));
        }
        if (pScrollY > 0.0) {
            this.scroll = Mth.clamp((int)(this.scroll - 4), (int)0, (int)(((PSUContainer)this.menu).handler.getSlots() - 8));
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.children().forEach(listener -> {
            if (listener instanceof GUISlot && ((GUISlot)((Object)listener)).isHovered()) {
                listener.keyPressed(keyCode, scanCode, modifiers);
            }
        });
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBg(@Nonnull GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        gg.blit(this.GUI, this.leftPos, this.topPos, 0.0f, 0.0f, 176, 180, 176, 180);
    }

    protected void renderLabels(@Nonnull GuiGraphics gg, int mouseX, int mouseY) {
        gg.drawString(this.font, this.title.getString(), 7, 6, 0x404040, false);
    }

    public void render(@Nonnull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gg, mouseX, mouseY, partialTicks);
        super.render(gg, mouseX, mouseY, partialTicks);
        this.renderTooltip(gg, mouseX, mouseY);
    }

    protected void renderTooltip(@Nonnull GuiGraphics gg, int x, int y) {
        this.children().forEach(listener -> {
            if (listener instanceof GUISlot) {
                ((GUISlot)((Object)listener)).renderToolTip(gg, x, y);
            }
        });
        super.renderTooltip(gg, x, y);
    }

    class GUISlot
    extends Button {
        public final int slot;

        public GUISlot(int x, int y, int width, int height, int slotIn, Button.OnPress pressable) {
            super(x, y, width, height, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
            this.slot = slotIn;
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            if (this.active && this.visible) {
                if (pButton == 0 && this.clicked(pMouseX, pMouseY)) {
                    this.onClick(pMouseX, pMouseY);
                    return true;
                }
                if (pButton == 1 && this.clicked(pMouseX, pMouseY)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SlotClickPacket(this.slot + PSUGui.this.scroll, Screen.hasShiftDown(), Screen.hasControlDown(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ((PSUContainer)PSUGui.this.menu).networkSlotClick(this.slot + PSUGui.this.scroll, Screen.hasShiftDown(), Screen.hasControlDown(), true);
                    return true;
                }
            }
            return false;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (Minecraft.getInstance().options.keyDrop.matches(keyCode, scanCode)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SlotKeyPacket(this.slot + PSUGui.this.scroll, SlotKeyPacket.Key.DROP, Screen.hasControlDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PSUContainer)PSUGui.this.menu).networkSlotKeyPress(this.slot + PSUGui.this.scroll, SlotKeyPacket.Key.DROP, Screen.hasControlDown());
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void renderToolTip(@Nonnull GuiGraphics gg, int mx, int my) {
            ItemStack stack;
            if (mx >= this.getX() && mx < this.getX() + this.width && my >= this.getY() && my < this.getY() + this.height && PSUGui.this.menu != null && ((PSUContainer)((PSUGui)PSUGui.this).menu).handler != null && !(stack = ((PSUContainer)((PSUGui)PSUGui.this).menu).handler.getStackInSlot(this.slot + PSUGui.this.scroll)).isEmpty()) {
                List tooltip = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack);
                tooltip.add(Component.translatable((String)"pocketstorage.util.count").withStyle(ChatFormatting.WHITE).append(String.valueOf(stack.getCount())));
                gg.renderComponentTooltip(PSUGui.this.font, tooltip, mx, my);
            }
        }

        public String formatAmount(int input) {
            if (input >= 1000 && input < 1000000) {
                return String.format("%.2fK", Float.valueOf((float)input / 1000.0f));
            }
            if (input >= 1000000 && input < 1000000000) {
                return String.format("%.2fM", Float.valueOf((float)input / 1000000.0f));
            }
            if (input >= 1000000000) {
                return String.format("%.2fG", Float.valueOf((float)input / 1.0E9f));
            }
            return String.valueOf(input);
        }

        public void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            ItemStack tmp;
            gg.pose().pushPose();
            Font fontRenderer = Minecraft.getInstance().font;
            boolean hovered = this.isHovered;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (hovered) {
                gg.fill(this.getX(), this.getY() - 1, this.getX() + this.width, this.getY() + this.height, -2130706433);
            }
            gg.pose().pushPose();
            gg.pose().translate((double)this.getX() + 0.5, (double)this.getY() + 0.5, 0.0);
            gg.pose().scale(0.5f, 0.5f, 0.5f);
            gg.drawString(PSUGui.this.font, "#" + (this.slot + PSUGui.this.scroll), 0, 0, 0x454545, false);
            gg.pose().popPose();
            if (((PSUContainer)((PSUGui)PSUGui.this).menu).handler != null && (tmp = ((PSUContainer)((PSUGui)PSUGui.this).menu).handler.getStackInSlot(this.slot + PSUGui.this.scroll)) != null) {
                RenderSystem.enableDepthTest();
                Lighting.setupForFlatItems();
                gg.renderItem(tmp, this.getX() + 9, this.getY() + 4);
                if (tmp.getCount() > 0) {
                    String count = Integer.toString(tmp.getCount());
                    int stringWidth = fontRenderer.width(count);
                    gg.drawString(PSUGui.this.font, this.formatAmount(tmp.getCount()), this.getX() + 1 + this.width / 2 - stringWidth / 2, this.getY() + 22, 0, false);
                } else {
                    gg.drawString(PSUGui.this.font, (Component)Component.translatable((String)"pocketstorage.util.empty"), this.getX() + 1 + this.width / 2 - fontRenderer.width((FormattedText)Component.translatable((String)"pocketstorage.util.empty")) / 2, this.getY() + 20, 0, false);
                }
                Lighting.setupFor3DItems();
            }
            gg.pose().popPose();
        }
    }

    class ScrollButton
    extends Button {
        private final boolean up;
        private final ResourceLocation TEX = ResourceLocation.fromNamespaceAndPath((String)"pocketstorage", (String)"textures/gui/buttons.png");

        public ScrollButton(PSUGui this$0, int x, int y, int width, int height, boolean upIn, Button.OnPress pressable) {
            super(x, y, width, height, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
            this.up = upIn;
        }

        public void renderWidget(@Nonnull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            if (mouseX >= this.getX() && mouseX < this.getX() + this.width && mouseY >= this.getY() && mouseY < this.getY() + this.height) {
                gg.blit(this.TEX, this.getX(), this.getY(), 16.0f, this.up ? 0.0f : 37.0f, 16, 37, 32, 74);
            } else {
                gg.blit(this.TEX, this.getX(), this.getY(), 0.0f, this.up ? 0.0f : 37.0f, 16, 37, 32, 74);
            }
        }
    }
}

