/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.holosigns.registry;

import com.mojang.serialization.Codec;
import com.mrbysco.holosigns.registry.SignReg;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SignRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"holosigns");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"holosigns");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"holosigns");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"holosigns");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"holosigns");
    public static final List<SignReg> SIGNS = new ArrayList<SignReg>();
    public static final SignReg GLASS = SignRegistry.registerSign("glass", MapColor.NONE, SoundType.GLASS);
    public static final SignReg WHITE_STAINED_GLASS = SignRegistry.registerSign("white_stained_glass", DyeColor.WHITE.getMapColor(), SoundType.GLASS);
    public static final SignReg ORANGE_STAINED_GLASS = SignRegistry.registerSign("orange_stained_glass", DyeColor.ORANGE.getMapColor(), SoundType.GLASS);
    public static final SignReg MAGENTA_STAINED_GLASS = SignRegistry.registerSign("magenta_stained_glass", DyeColor.MAGENTA.getMapColor(), SoundType.GLASS);
    public static final SignReg LIGHT_BLUE_STAINED_GLASS = SignRegistry.registerSign("light_blue_stained_glass", DyeColor.LIGHT_BLUE.getMapColor(), SoundType.GLASS);
    public static final SignReg YELLOW_STAINED_GLASS = SignRegistry.registerSign("yellow_stained_glass", DyeColor.YELLOW.getMapColor(), SoundType.GLASS);
    public static final SignReg LIME_STAINED_GLASS = SignRegistry.registerSign("lime_stained_glass", DyeColor.LIME.getMapColor(), SoundType.GLASS);
    public static final SignReg PINK_STAINED_GLASS = SignRegistry.registerSign("pink_stained_glass", DyeColor.PINK.getMapColor(), SoundType.GLASS);
    public static final SignReg GRAY_STAINED_GLASS = SignRegistry.registerSign("gray_stained_glass", DyeColor.GRAY.getMapColor(), SoundType.GLASS);
    public static final SignReg LIGHT_GRAY_STAINED_GLASS = SignRegistry.registerSign("light_gray_stained_glass", DyeColor.LIGHT_GRAY.getMapColor(), SoundType.GLASS);
    public static final SignReg CYAN_STAINED_GLASS = SignRegistry.registerSign("cyan_stained_glass", DyeColor.CYAN.getMapColor(), SoundType.GLASS);
    public static final SignReg PURPLE_STAINED_GLASS = SignRegistry.registerSign("purple_stained_glass", DyeColor.PURPLE.getMapColor(), SoundType.GLASS);
    public static final SignReg BLUE_STAINED_GLASS = SignRegistry.registerSign("blue_stained_glass", DyeColor.BLUE.getMapColor(), SoundType.GLASS);
    public static final SignReg BROWN_STAINED_GLASS = SignRegistry.registerSign("brown_stained_glass", DyeColor.BROWN.getMapColor(), SoundType.GLASS);
    public static final SignReg GREEN_STAINED_GLASS = SignRegistry.registerSign("green_stained_glass", DyeColor.GREEN.getMapColor(), SoundType.GLASS);
    public static final SignReg RED_STAINED_GLASS = SignRegistry.registerSign("red_stained_glass", DyeColor.RED.getMapColor(), SoundType.GLASS);
    public static final SignReg BLACK_STAINED_GLASS = SignRegistry.registerSign("black_stained_glass", DyeColor.BLACK.getMapColor(), SoundType.GLASS);
    public static final Supplier<AttachmentType<Boolean>> INVISIBLE = ATTACHMENT_TYPES.register("invisible", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SIGN_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> GLASS.getSignItem().toStack()).title((Component)Component.translatable((String)"itemGroup.holosigns")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());

    public static SignReg registerSign(String name, MapColor color, SoundType soundType) {
        SignReg reg = new SignReg(name, color, soundType);
        SIGNS.add(reg);
        return reg;
    }

    public static void addBlockEntityTypes(BlockEntityTypeAddBlocksEvent event) {
        for (SignReg reg : SIGNS) {
            event.modify(BlockEntityType.SIGN, new Block[]{(Block)reg.getSign().get(), (Block)reg.getWallSign().get()});
            event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)reg.getHangingSign().get(), (Block)reg.getWallHangingSign().get()});
        }
    }
}

