/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.holosigns.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.holosigns.registry.SignRegistry;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SignRenderer.class})
public abstract class SignRendererMixin {
    @Shadow
    abstract void renderSignText(BlockPos var1, SignText var2, PoseStack var3, MultiBufferSource var4, int var5, int var6, int var7, boolean var8);

    @Shadow
    abstract void renderSignModel(PoseStack var1, int var2, int var3, Model var4, VertexConsumer var5);

    @Shadow
    public abstract float getSignModelRenderScale();

    @Shadow
    abstract Material getSignMaterial(WoodType var1);

    @Inject(method={"renderSignWithText(Lnet/minecraft/world/level/block/entity/SignBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/SignBlock;Lnet/minecraft/world/level/block/state/properties/WoodType;Lnet/minecraft/client/model/Model;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/SignRenderer;translateSign(Lcom/mojang/blaze3d/vertex/PoseStack;FLnet/minecraft/world/level/block/state/BlockState;)V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    public void holosigns$renderSignWithText(SignBlockEntity signEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, BlockState state, SignBlock signBlock, WoodType woodType, Model model, CallbackInfo ci) {
        if (signEntity.hasData(SignRegistry.INVISIBLE)) {
            this.renderSignText(signEntity.getBlockPos(), signEntity.getFrontText(), poseStack, buffer, packedLight, signEntity.getTextLineHeight(), signEntity.getMaxTextLineWidth(), true);
            this.renderSignText(signEntity.getBlockPos(), signEntity.getBackText(), poseStack, buffer, packedLight, signEntity.getTextLineHeight(), signEntity.getMaxTextLineWidth(), false);
            poseStack.popPose();
            ci.cancel();
        }
    }

    @Inject(method={"renderSign(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/level/block/state/properties/WoodType;Lnet/minecraft/client/model/Model;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void holosigns$renderSign(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, WoodType woodType, Model model, CallbackInfo ci) {
        if (woodType.name().startsWith("holosigns") && woodType.name().endsWith("_stained_glass")) {
            poseStack.pushPose();
            float f = this.getSignModelRenderScale();
            poseStack.scale(f, -f, -f);
            Material material = this.getSignMaterial(woodType);
            VertexConsumer vertexconsumer = material.buffer(buffer, RenderType::entityTranslucent);
            this.renderSignModel(poseStack, packedLight, packedOverlay, model, vertexconsumer);
            poseStack.popPose();
            ci.cancel();
        }
    }
}

