/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.holosigns.datagen.server;

import com.mrbysco.holosigns.registry.SignReg;
import com.mrbysco.holosigns.registry.SignRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class SignRecipeProvider
extends RecipeProvider {
    public SignRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider provider) {
        this.generateSigns(output, (ItemLike)Blocks.GLASS, SignRegistry.GLASS);
        this.generateSigns(output, (ItemLike)Blocks.WHITE_STAINED_GLASS, SignRegistry.WHITE_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.ORANGE_STAINED_GLASS, SignRegistry.ORANGE_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.MAGENTA_STAINED_GLASS, SignRegistry.MAGENTA_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS, SignRegistry.LIGHT_BLUE_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.YELLOW_STAINED_GLASS, SignRegistry.YELLOW_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.LIME_STAINED_GLASS, SignRegistry.LIME_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.PINK_STAINED_GLASS, SignRegistry.PINK_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.GRAY_STAINED_GLASS, SignRegistry.GRAY_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS, SignRegistry.LIGHT_GRAY_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.CYAN_STAINED_GLASS, SignRegistry.CYAN_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.PURPLE_STAINED_GLASS, SignRegistry.PURPLE_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.BLUE_STAINED_GLASS, SignRegistry.BLUE_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.BROWN_STAINED_GLASS, SignRegistry.BROWN_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.GREEN_STAINED_GLASS, SignRegistry.GREEN_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.RED_STAINED_GLASS, SignRegistry.RED_STAINED_GLASS);
        this.generateSigns(output, (ItemLike)Blocks.BLACK_STAINED_GLASS, SignRegistry.BLACK_STAINED_GLASS);
    }

    private void generateSigns(RecipeOutput output, ItemLike material, SignReg sign) {
        this.generateSign(output, material, (ItemLike)sign.getSignItem());
        this.generateHangingSign(output, material, (ItemLike)sign.getHangingSignItem());
    }

    private void generateSign(RecipeOutput output, ItemLike material, ItemLike sign) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)6).pattern("###").pattern("###").pattern(" S ").group("sign").define(Character.valueOf('#'), material).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_material", SignRecipeProvider.has((ItemLike)material)).save(output);
    }

    private void generateHangingSign(RecipeOutput output, ItemLike material, ItemLike sign) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sign, (int)6).pattern("X X").pattern("###").pattern("###").group("hanging_sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).unlockedBy("has_material", SignRecipeProvider.has((ItemLike)material)).save(output);
    }
}

