/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.TradeMatcher;
import com.almostreliable.morejs.features.villager.VillagerUtils;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.npc.VillagerTrades;

public class WandererTradingEventJS
implements KubeEvent {
    private final Int2ObjectMap<List<VillagerTrades.ItemListing>> trades;

    public WandererTradingEventJS(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        this.trades = trades;
    }

    public List<VillagerTrades.ItemListing> getTrades(int level) {
        this.checkLevel(level);
        return (List)this.trades.computeIfAbsent(level, $ -> new ArrayList());
    }

    public SimpleTrade addTrade(int level, TradeItem[] inputs, TradeItem output) {
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Sell item cannot be empty");
        Preconditions.checkArgument((inputs.length != 0 ? 1 : 0) != 0, (Object)"Buyer items cannot be empty");
        Preconditions.checkArgument((boolean)Arrays.stream(inputs).noneMatch(TradeItem::isEmpty), (Object)"Buyer items cannot be empty");
        SimpleTrade trade = VillagerUtils.createSimpleTrade(inputs, output);
        return this.addTrade(level, trade);
    }

    public <T extends VillagerTrades.ItemListing> T addTrade(int level, T trade) {
        Objects.requireNonNull(trade);
        this.getTrades(level).add(trade);
        return trade;
    }

    public void addCustomTrade(int level, TransformableTrade.Transformer transformer) {
        this.getTrades(level).add(new CustomTrade(transformer));
    }

    public void removeTrades(TradeFilter filter) {
        this.trades.forEach((level, listings) -> {
            TradeMatcher matcher = new TradeMatcher(filter, (first, second, output) -> ConsoleJS.SERVER.info((Object)("Removing wanderer trade for level " + level + ": " + String.valueOf(first) + " & " + String.valueOf(second) + " -> " + String.valueOf(output))));
            if (matcher.matchMerchantLevel((int)level)) {
                listings.removeIf(itemListing -> {
                    if (itemListing instanceof TradeMatcher.Filterable) {
                        TradeMatcher.Filterable filterable = (TradeMatcher.Filterable)itemListing;
                        return filterable.matchesTradeFilter(matcher);
                    }
                    return false;
                });
            }
        });
    }

    public void removeVanillaTrades() {
        this.getTrades(1).removeIf(VillagerUtils::isVanillaTypedTrade);
        this.getTrades(2).removeIf(VillagerUtils::isVanillaTypedTrade);
    }

    public void removeVanillaTrades(int level) {
        this.checkLevel(level);
        this.getTrades(level).removeIf(VillagerUtils::isVanillaTypedTrade);
    }

    public void removeModdedTrades() {
        this.getTrades(1).removeIf(VillagerUtils::isModdedTypedTrade);
        this.getTrades(2).removeIf(VillagerUtils::isModdedTypedTrade);
    }

    public void removeModdedTrades(int level) {
        this.checkLevel(level);
        this.getTrades(level).removeIf(VillagerUtils::isModdedTypedTrade);
    }

    private void checkLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 2 ? 1 : 0) != 0, (Object)"Level must be between 1 and 2");
    }
}

