/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.resources;

import dev.ftb.mods.ftbmaterials.resources.ResourceType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public enum Resource {
    ALUMINUM(Resource.builder().noGem().build()),
    APATITE(Resource.builder().noOres().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    BRONZE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().build()),
    CHARCOAL(Resource.builder().noOres().noIngot().noBlock().noRawOre().noWire().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    CONSTANTAN(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    COPPER(Resource.builder().noDeepslateOre().noStoneOre().noBlock().noIngot().noRawOre().noRawBlock().noGem().build()),
    DIAMOND(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noBlade().build()),
    ELECTRUM(Resource.builder().noOres().noRawOre().noRawBlock().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    GOLD(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noDeepslateOre().noStoneOre().noBlock().noIngot().noNugget().noRawOre().noRawBlock().noBlade().build()),
    GRAPHITE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    INVAR(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    IRON(Resource.builder().noRawOre().noStoneOre().noDeepslateOre().noRawBlock().noBlock().noIngot().noNugget().noGem().build()),
    LEAD(Resource.builder().noGem().noBlade().build()),
    LUMIUM(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noBlade().noChunk().noCluster().build()),
    NETHERITE(ResourceLocation.withDefaultNamespace((String)"needs_diamond_tool"), Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noIngot().noBlock().noChunk().noCluster().build()),
    NICKEL(Resource.builder().noGem().noBlade().build()),
    OBSIDIAN(Resource.builder().noOres().noIngot().noRawOre().noRawBlock().noNugget().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noBlock().noChunk().noCluster().build()),
    OSMIUM(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noGem().noBlade().build()),
    QUARTZ(Resource.builder().noCrystal().noBlock().noNetherOre().noIngot().noRawOre().noRawBlock().noGem().noBlade().build()),
    REFINED_GLOWSTONE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noChunk().noCluster().build()),
    SIGNALUM(Resource.builder().noOres().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    SILVER(Resource.builder().noBlade().build()),
    STEEL(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    SULFUR(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noGem().noBlade().noChunk().noCluster().build()),
    TIN(Resource.builder().noGem().build()),
    URANIUM(Resource.builder().noGem().noBlade().build()),
    ZINC(Resource.builder().noGem().noBlade().noChunk().noCluster().build()),
    REDSTONE(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noBlock().noDust().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().build()),
    FLUORITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().build()),
    EMERALD(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().build()),
    LAPIS_LAZULI(Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().build()),
    RESONATING_ORE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    DIMENSIONAL_SHARD(ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"), Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    ANTIMONY(Resource.builder().noPlate().noGear().noRod().noGem().noBlade().noChunk().noCluster().build()),
    BAUXITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    IRIDIUM(Resource.builder().noGear().noRod().noGem().noBlade().noChunk().noCluster().build()),
    MONAZITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    TUNGSTEN(Resource.builder().noGear().noGem().noBlade().noChunk().noCluster().build()),
    TITANIUM(Resource.builder().noGem().noChunk().noCluster().build()),
    PLATINUM(Resource.builder().noGem().noBlade().build()),
    STAINLESS_STEEL(Resource.builder().noOres().noIngot().noRawOre().noRawBlock().noNugget().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().build()),
    PLUTONIUM(Resource.builder().noOres().noChunk().noCluster().build()),
    CHROMIUM(Resource.builder().noOres().noChunk().noCluster().build()),
    SILICON(Resource.builder().noOres().noChunk().noCluster().build()),
    BRASS(Resource.builder().noOres().noChunk().noCluster().build()),
    COAL(Resource.builder().noStoneOre().noDeepslateOre().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noBlade().noDust().noGear().noRod().noWire().noPlate().build());

    private final int resourceComponents;
    private ResourceLocation breakableWith = ResourceLocation.withDefaultNamespace((String)"needs_stone_tool");

    private Resource(int resourceComponents) {
        this.resourceComponents = resourceComponents;
    }

    private Resource(ResourceLocation breakableWith, int resourceComponents) {
        this.resourceComponents = resourceComponents;
        this.breakableWith = breakableWith;
    }

    public boolean hasComponent(ResourceType type) {
        return (this.resourceComponents & 1 << type.getId()) != 0;
    }

    public Set<ResourceType> getComponents() {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        for (ResourceType type : ResourceType.values()) {
            if (!this.hasComponent(type)) continue;
            types.add(type);
        }
        return types;
    }

    public ResourceLocation getBreakableWith() {
        return this.breakableWith;
    }

    private static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    private static class ResourceBuilder {
        private int resourceComponents = 0;

        public ResourceBuilder() {
            for (ResourceType type : ResourceType.values()) {
                this.resourceComponents |= 1 << type.getId();
            }
        }

        public ResourceBuilder noType(ResourceType type) {
            this.resourceComponents &= ~(1 << type.getId());
            return this;
        }

        public ResourceBuilder noOres() {
            return this.noStoneOre().noDeepslateOre().noEndOre().noNetherOre();
        }

        public ResourceBuilder noStoneOre() {
            return this.noType(ResourceType.STONE_ORE);
        }

        public ResourceBuilder noDeepslateOre() {
            return this.noType(ResourceType.DEEPSLATE_ORE);
        }

        public ResourceBuilder noEndOre() {
            return this.noType(ResourceType.END_ORE);
        }

        public ResourceBuilder noNetherOre() {
            return this.noType(ResourceType.NETHER_ORE);
        }

        public ResourceBuilder noBlock() {
            return this.noType(ResourceType.BLOCK);
        }

        public ResourceBuilder noIngot() {
            return this.noType(ResourceType.INGOT);
        }

        public ResourceBuilder noRawOre() {
            return this.noType(ResourceType.RAW_ORE);
        }

        public ResourceBuilder noRawBlock() {
            return this.noType(ResourceType.RAW_BLOCK);
        }

        public ResourceBuilder noNugget() {
            return this.noType(ResourceType.NUGGET);
        }

        public ResourceBuilder noDust() {
            return this.noType(ResourceType.DUST);
        }

        public ResourceBuilder noPlate() {
            return this.noType(ResourceType.PLATE);
        }

        public ResourceBuilder noGear() {
            return this.noType(ResourceType.GEAR);
        }

        public ResourceBuilder noRod() {
            return this.noType(ResourceType.ROD);
        }

        public ResourceBuilder noGem() {
            return this.noType(ResourceType.GEM);
        }

        public ResourceBuilder noCrystal() {
            return this.noType(ResourceType.CRYSTAL);
        }

        public ResourceBuilder noWire() {
            return this.noType(ResourceType.WIRE);
        }

        public ResourceBuilder noShard() {
            return this.noType(ResourceType.SHARD);
        }

        public ResourceBuilder noClump() {
            return this.noType(ResourceType.CLUMP);
        }

        public ResourceBuilder noDirtyDust() {
            return this.noType(ResourceType.DIRTY_DUST);
        }

        public ResourceBuilder noBlade() {
            return this.noType(ResourceType.BLADE);
        }

        public ResourceBuilder noChunk() {
            return this.noType(ResourceType.CHUNK);
        }

        public ResourceBuilder noCluster() {
            return this.noType(ResourceType.CLUSTER);
        }

        public int build() {
            return this.resourceComponents;
        }
    }
}

