/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.jei;

import com.heaser.pipeconnector.constants.TagKeys;
import com.heaser.pipeconnector.items.ModItems;
import com.heaser.pipeconnector.items.PipeConnectorItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SupportedPipesRecipeInfo {
    public final ItemStack inputIngredient = ((PipeConnectorItem)((Object)ModItems.PIPE_CONNECTOR.get())).getDefaultInstance();
    public final List<Holder<Item>> supportedPipes;

    private SupportedPipesRecipeInfo(List<Holder<Item>> supportedPipes) {
        this.supportedPipes = supportedPipes;
    }

    public static List<SupportedPipesRecipeInfo> create() {
        ArrayList<SupportedPipesRecipeInfo> recipes = new ArrayList<SupportedPipesRecipeInfo>();
        int maxSlotsPerRow = 9;
        int maxRows = 6;
        int slotsPerPage = maxSlotsPerRow * maxRows;
        HolderSet.Named supportedPipesHolderSet = (HolderSet.Named)BuiltInRegistries.ITEM.getTag(TagKeys.PLACEABLE_ITEMS).get();
        List<Holder> supportedPipes = supportedPipesHolderSet.stream().sorted(Comparator.comparing(item -> ((Item)item.value()).getDescriptionId())).toList();
        int pagesNum = (int)Math.ceil((float)supportedPipes.size() / (float)slotsPerPage);
        for (int page = 0; page < pagesNum; ++page) {
            List<Holder<Item>> supportedPipesInPage = supportedPipes.subList(page * slotsPerPage, Math.min((page + 1) * slotsPerPage, supportedPipes.size()));
            SupportedPipesRecipeInfo recipePage = new SupportedPipesRecipeInfo(supportedPipesInPage);
            recipes.add(recipePage);
        }
        return recipes;
    }
}

