/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.gtceu;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GTCEUCompatibility
implements IPlacer {
    public static Class<? extends Block> getBlockToRegister() {
        return PipeBlock.class;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> adjacentDirectionSides) {
        if (item instanceof PipeBlockItem) {
            BlockState blockState = Block.byItem((Item)item).defaultBlockState();
            boolean superVal = level.setBlock(pos, blockState, 11);
            if (superVal && !level.isClientSide) {
                PipeBlockItem pipeBlockItem = (PipeBlockItem)item;
                IPipeNode selfTile = pipeBlockItem.getBlock().getPipeTile((BlockGetter)level, pos);
                if (selfTile == null) {
                    return true;
                }
                for (Direction side : adjacentDirectionSides) {
                    if (!selfTile.getPipeBlock().canConnect(selfTile, side)) continue;
                    selfTile.setConnection(side, true, false);
                }
                for (Direction facing : GTUtil.DIRECTIONS) {
                    BlockEntity te = selfTile.getNeighbor(facing);
                    if (te instanceof IPipeNode) {
                        IPipeNode otherPipe = (IPipeNode)te;
                        if (!otherPipe.isConnected(facing.getOpposite())) continue;
                        if (otherPipe.getPipeBlock().canPipesConnect(otherPipe, facing.getOpposite(), selfTile)) {
                            selfTile.setConnection(facing, true, true);
                            continue;
                        }
                        otherPipe.setConnection(facing.getOpposite(), false, true);
                        continue;
                    }
                    if (ConfigHolder.INSTANCE.machines.gt6StylePipesCables || !selfTile.getPipeBlock().canPipeConnectToBlock(selfTile, facing, te)) continue;
                    selfTile.setConnection(facing, true, false);
                }
                selfTile.notifyBlockUpdate();
            }
            return superVal;
        }
        return false;
    }
}

