/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.typed;

public class TypeConvertors {
    public static boolean toBoolean(Object v) {
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v == null) {
            return false;
        }
        if (v instanceof Byte) {
            Byte b = (Byte)v;
            return b != 0;
        }
        if (v instanceof Short) {
            Short b = (Short)v;
            return b != 0;
        }
        if (v instanceof Long) {
            Long b = (Long)v;
            return b != 0L;
        }
        if (v instanceof Integer) {
            Integer b = (Integer)v;
            return b != 0;
        }
        if (v instanceof Double) {
            Double b = (Double)v;
            return b != 0.0;
        }
        if (v instanceof Float) {
            Float b = (Float)v;
            return b.floatValue() != 0.0f;
        }
        if (v instanceof String) {
            String b = (String)v;
            return !b.isEmpty();
        }
        return false;
    }

    public static int toInt(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v == null) {
            return 0;
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return b != false ? 1 : 0;
        }
        if (v instanceof Double) {
            Double b = (Double)v;
            return b.intValue();
        }
        if (v instanceof Float) {
            Float b = (Float)v;
            return (int)b.floatValue();
        }
        if (v instanceof Long) {
            Long b = (Long)v;
            return b.intValue();
        }
        if (v instanceof Short) {
            Short b = (Short)v;
            return b.shortValue();
        }
        if (v instanceof Byte) {
            Byte b = (Byte)v;
            return b.byteValue();
        }
        if (v instanceof String) {
            String b = (String)v;
            return Integer.parseInt(b);
        }
        return 0;
    }
}

