/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.WindowTools;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.Tools;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class GenericGuiContainer<T extends GenericTileEntity, C extends AbstractContainerMenu>
extends AbstractContainerScreen<C>
implements IKeyReceiver {
    protected Window window;
    private WindowManager windowManager;
    private final GuiSideWindow sideWindow;

    public void setWindowDimensions(int x, int y) {
        this.imageWidth = x;
        this.imageHeight = y;
    }

    public GenericGuiContainer(C container, Inventory inventory, Component title, ManualEntry manualEntry) {
        super(container, inventory, title);
        this.sideWindow = new GuiSideWindow(manualEntry.manual(), manualEntry.entry(), manualEntry.page());
        this.windowManager = null;
    }

    public <T extends GenericTileEntity> T getBE() {
        GenericTileEntity genericTileEntity;
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof GenericContainer) {
            GenericContainer container = (GenericContainer)abstractContainerMenu;
            genericTileEntity = container.getBe();
        } else {
            genericTileEntity = null;
        }
        return (T)((Object)genericTileEntity);
    }

    public List<Rect2i> getExtraWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getExtraWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        ArrayList<Rect2i> bounds = new ArrayList<Rect2i>();
        Rectangle r1 = this.sideWindow.getWindow().getToplevel().getBounds();
        bounds.add(new Rect2i(r1.x, r1.y, r1.width, r1.height));
        if (this.windowManager != null) {
            for (Window w : this.windowManager.getWindows()) {
                Rectangle r = w.getToplevel().getBounds();
                bounds.add(new Rect2i(r.x, r.y, r.width, r.height));
            }
        }
        return bounds;
    }

    public void init() {
        this.windowManager = null;
        super.init();
        this.sideWindow.initGui(this.minecraft, (Screen)this, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            if (this.sideWindow.getWindow() == null) {
                RuntimeException e = new RuntimeException("Internal error! getWindowManager() called before initGui!");
                Logging.getLogger().error((Object)e);
                throw e;
            }
            this.windowManager = new WindowManager((Screen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void renderLabels(@Nonnull GuiGraphics graphics, int p_230451_2_, int p_230451_3_) {
        this.getWindowManager().drawTooltips(graphics);
    }

    public void drawHoveringText(GuiGraphics graphics, List<String> textLines, List<ItemStack> items, int x, int y, Font font) {
        if (!textLines.isEmpty()) {
            PoseStack matrixStack = graphics.pose();
            matrixStack.pushPose();
            RenderSystem.disableDepthTest();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s != null && items != null && s.contains("@") && !items.isEmpty()) {
                    List<Object> list = WindowTools.parseString(s, items);
                    boolean lineHasItemStacks = false;
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.width((String)o);
                            continue;
                        }
                        j += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        ++linesWithItemStacks;
                    }
                } else {
                    j = font.width(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx > this.width - this.leftPos - i - 5) {
                xx -= 28 + i;
            }
            if (xx < 4 - this.leftPos) {
                xx = 4 - this.leftPos;
            }
            if (yy > this.height - this.topPos - k - 4) {
                yy = this.height - this.topPos - k - 4;
            } else if (yy < 4 - this.topPos) {
                yy = 4 - this.topPos;
            }
            int l = -267386864;
            graphics.fillGradient(xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            graphics.fillGradient(xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            graphics.fillGradient(xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            graphics.fillGradient(xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            graphics.fillGradient(xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            graphics.fillGradient(xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            graphics.fillGradient(xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            graphics.fillGradient(xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            graphics.fillGradient(xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            matrixStack.translate(0.0, 0.0, 300.0);
            this.renderTextLines(graphics, textLines, items, font, xx, yy);
            RenderSystem.enableDepthTest();
            matrixStack.popPose();
        }
    }

    private void renderTextLines(GuiGraphics graphics, List<String> textLines, List<ItemStack> items, Font font, int xx, int yy) {
        for (int i = 0; i < textLines.size(); ++i) {
            String s1 = textLines.get(i);
            if (s1 != null && items != null && s1.contains("@") && !items.isEmpty()) {
                List<Object> list = WindowTools.parseString(s1, items);
                int curx = xx;
                boolean lineHasItemStacks = false;
                for (Object o : list) {
                    if (o instanceof String) {
                        String s2 = (String)o;
                        font.drawInBatch(s2, (float)curx, (float)yy, 0xFFFFFF, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                        curx += font.width(s2);
                        continue;
                    }
                    RenderHelper.renderObject(graphics, curx + 1, yy, o, false);
                    curx += 20;
                    lineHasItemStacks = true;
                }
                if (lineHasItemStacks) {
                    yy += 8;
                }
            } else {
                font.drawInBatch(s1, (float)xx, (float)yy, 0xFFFFFF, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            if (i == 0) {
                yy += 2;
            }
            yy += 10;
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawWindow(graphics, partialTicks, x, y);
    }

    protected void drawWindow(GuiGraphics graphics, float partialTicks, int x, int y) {
        if (this.window == null) {
            return;
        }
        T te = this.getBE();
        if (te != null) {
            this.getWindowManager().syncBindings(te);
        }
        this.getWindowManager().draw(graphics);
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.window == null) {
            return;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.drawStackTooltips(graphics, mouseX, mouseY);
    }

    public void renderSlot(@Nonnull GuiGraphics graphics, @Nonnull Slot slot) {
        if (!this.isPartiallyCoveredByModalWindow(slot)) {
            super.renderSlot(graphics, slot);
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot == null) {
            return null;
        }
        if (this.isPartiallyCoveredByModalWindow(slot)) {
            return null;
        }
        return slot;
    }

    public boolean isHovering(@Nonnull Slot slotIn, double mouseX, double mouseY) {
        if (this.isPartiallyCoveredByModalWindow(slotIn)) {
            return false;
        }
        return super.isHovering(slotIn, mouseX, mouseY);
    }

    private boolean isPartiallyCoveredByModalWindow(Slot slotIn) {
        int xPos = slotIn.x + this.window.getToplevel().getBounds().x;
        int yPos = slotIn.y + this.window.getToplevel().getBounds().y;
        return this.getWindowManager().getModalWindows().anyMatch(window -> window.getToplevel().getBounds().intersects(new Rectangle(xPos, yPos, 18, 18)));
    }

    protected void drawStackTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        BlockRender blockRender;
        Object renderItem;
        ItemStack itemStack;
        int x = GuiTools.getRelativeX(this.window.getGui());
        int y = GuiTools.getRelativeY(this.window.getGui());
        Widget<?> widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && !(itemStack = (renderItem = (blockRender = (BlockRender)widget).getRenderItem()) instanceof ItemStack ? (ItemStack)renderItem : (renderItem instanceof Block ? new ItemStack((ItemLike)((Block)renderItem)) : (renderItem instanceof Item ? new ItemStack((ItemLike)((Item)renderItem)) : ItemStack.EMPTY))).isEmpty()) {
            this.customRenderToolTip(graphics, blockRender, itemStack, mouseX, mouseY);
        }
    }

    protected List<Component> addCustomLines(List<Component> oldList, BlockRender blockRender, ItemStack stack) {
        return oldList;
    }

    protected void customRenderToolTip(GuiGraphics graphics, BlockRender blockRender, ItemStack stack, int x, int y) {
        List<Object> list;
        if (stack.getItem() == null) {
            list = new ArrayList<Component>();
        } else {
            TooltipFlag.Default flag = this.getMinecraft().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            list = stack.getTooltipLines(Item.TooltipContext.of((Level)this.getMinecraft().level), (Player)this.getMinecraft().player, (TooltipFlag)flag);
        }
        list = this.addCustomLines(list, blockRender, stack);
        graphics.renderTooltip(this.getMinecraft().font, list, Optional.empty(), stack, x, y);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        super.removed();
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean rc = super.mouseClicked(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseClicked(x, y, button);
        }
        return rc;
    }

    public boolean mouseDragged(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.mouseDragged(x, y, button, scaledX, scaledY);
        if (this.window != null) {
            this.getWindowManager().mouseDragged(x, y, button);
        }
        return rc;
    }

    public boolean mouseScrolled(double x, double y, double dx, double dy) {
        boolean rc = super.mouseScrolled(x, y, dx, dy);
        if (this.window != null) {
            this.getWindowManager().mouseScrolled(x, y, dx, dy);
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean rc = super.mouseReleased(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseReleased(x, y, button);
        }
        return rc;
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean b;
        boolean bl = b = this.window == null || this.getWindowManager().keyTyped(keyCode, scanCode);
        if (b) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    @Override
    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    @Override
    public boolean mouseScrolledFromEvent(double x, double y, double dx, double dy) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, dx, dy);
        return true;
    }

    @Override
    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.getWindowManager().keyTyped(keyCode, scanCode)) {
            super.keyPressed(keyCode, scanCode, 0);
        }
    }

    @Override
    public void charTypedFromEvent(char codePoint) {
        if (this.window == null || this.getWindowManager().charTyped(codePoint)) {
            // empty if block
        }
    }

    public <T> void setValue(Value<?, T> value, T v) {
        this.sendServerCommandTyped(((GenericTileEntity)((Object)this.getBE())).getDimension(), GenericTileEntity.COMMAND_SYNC_BINDING.name(), TypedMap.builder().put(value.key(), v).build());
    }

    public void sendServerCommandTyped(String command, TypedMap params) {
        Networking.sendToServer(PacketServerCommandTyped.create(this.getBE().getBlockPos(), ((GenericTileEntity)((Object)this.getBE())).getDimension(), command, params));
    }

    public void sendServerCommandTyped(Command<?> command, TypedMap params) {
        Networking.sendToServer(PacketServerCommandTyped.create(this.getBE().getBlockPos(), ((GenericTileEntity)((Object)this.getBE())).getDimension(), command.name(), params));
    }

    public void sendServerCommandTyped(ResourceKey<Level> dimensionId, String command, TypedMap params) {
        Networking.sendToServer(PacketServerCommandTyped.create(this.getBE().getBlockPos(), dimensionId, command, params));
    }

    public void sendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        Networking.sendToServer(PacketSendServerCommand.create(modid, command, arguments));
    }

    public void sendServerCommand(String modid, String command) {
        Networking.sendToServer(PacketSendServerCommand.create(modid, command, TypedMap.EMPTY));
    }

    public static <C extends GenericContainer, S extends GenericGuiContainer<T, C>, T extends GenericTileEntity> void register(RegisterMenuScreensEvent event, MenuType<C> type, GuiSupplier<C, S, T> guiSupplier) {
        MenuScreens.ScreenConstructor factory = (container, inventory, title) -> {
            BlockEntity te = SafeClientTools.getClientWorld().getBlockEntity(container.getPos());
            return Tools.safeMap(te, tile -> guiSupplier.create(tile, container, inventory), "Invalid be entity!");
        };
        event.register(type, factory);
    }

    protected void updateEnergyBar(EnergyBar energyBar) {
        IEnergyStorage power = (IEnergyStorage)this.getBE().getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, this.getBE().getBlockPos(), null);
        if (power != null) {
            energyBar.maxValue(power.getMaxEnergyStored());
            energyBar.value(power.getEnergyStored());
        }
    }

    @FunctionalInterface
    public static interface GuiSupplier<C extends GenericContainer, S extends GenericGuiContainer, T extends GenericTileEntity> {
        public S create(T var1, C var2, Inventory var3);
    }
}

