/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Render;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class OutlineRendererMixin {
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void checkPoseStack(PoseStack var1);

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/debug/DebugRenderer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;DDD)V", shift=At.Shift.BEFORE, ordinal=0)})
    public void renderTracedViewPath(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matA, Matrix4f matB, CallbackInfo ci) {
        boolean isNonBridgeOutlineEnabled;
        boolean isInDebugMenu = this.minecraft.getDebugOverlay().showDebugScreen();
        boolean isBridgingEnabled = BridgingMod.getConfig().isBridgingEnabled() && (!BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || GameSupport.isControllerCrouching());
        boolean shouldRenderOutline = isInDebugMenu && BridgingMod.getConfig().shouldShowOutlineInF3() || !isInDebugMenu && BridgingMod.getConfig().shouldShowOutline();
        boolean isOutlineEnabled = shouldRenderOutline && isBridgingEnabled;
        boolean shouldRenderNonBridgeOutline = isInDebugMenu && BridgingMod.getConfig().shouldShowNonBridgeOutlineInF3() || !isInDebugMenu && BridgingMod.getConfig().shouldShowOutlineEvenWhenNotBridging();
        boolean bl = isNonBridgeOutlineEnabled = shouldRenderNonBridgeOutline && (isBridgingEnabled || !BridgingMod.getConfig().shouldNonBridgeRespectsCrouchRules());
        if (!isOutlineEnabled && !isNonBridgeOutlineEnabled) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = this.renderBuffers.bufferSource();
        VertexConsumer vertices = bufferSource.getBuffer(RenderType.lines());
        PoseStack poseStack = new PoseStack();
        if (isInDebugMenu && BridgingMod.getConfig().shouldShowDebugTrace()) {
            Render.blocksInViewPath(poseStack, vertices, camera);
        }
        if (isOutlineEnabled) {
            Render.currentBridgingOutline(poseStack, camera, vertices);
        }
        if (isNonBridgeOutlineEnabled) {
            Render.currentNonBridgingOutline(poseStack, camera, vertices);
        }
        this.checkPoseStack(poseStack);
    }
}

