/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.helper.Category;
import me.cg360.mod.bridging.config.helper.DefaultValueTracker;
import me.cg360.mod.bridging.config.helper.DiscreteRange;
import me.cg360.mod.bridging.config.helper.HideInConfigUI;
import me.cg360.mod.bridging.config.helper.IncludeAnimatedImage;
import me.cg360.mod.bridging.config.helper.IncludeExtraDescription;
import me.cg360.mod.bridging.config.helper.IncludeImage;
import me.cg360.mod.bridging.util.PlacementAxisMode;
import me.cg360.mod.bridging.util.PlacementAxisModeOverride;

public class BridgingConfig
extends DefaultValueTracker {
    public static ConfigClassHandler<BridgingConfig> HANDLER = ConfigClassHandler.createBuilder(BridgingConfig.class).id(BridgingMod.id("main")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(BridgingMod.getDefaultConfigPath().resolve("bridgingmod.json")).setJson5(false).build()).build();
    @SerialEntry
    @HideInConfigUI
    private int version = 3;
    @Category(value="feature")
    @SerialEntry
    @IncludeAnimatedImage(value="textures/gui/config/bridging.webp")
    @IncludeExtraDescription
    private boolean enableBridgingAssist = true;
    @Category(value="feature")
    @SerialEntry
    @IncludeExtraDescription
    private boolean onlyBridgeWhenCrouched = false;
    @Category(value="feature")
    @SerialEntry
    private PlacementAxisMode supportedBridgeAxes = PlacementAxisMode.BOTH;
    @Category(value="feature")
    @SerialEntry
    private PlacementAxisModeOverride supportedBridgeAxesWhenCrouched = PlacementAxisModeOverride.FALLBACK;
    @Category(value="feature")
    @SerialEntry
    @IncludeExtraDescription(extraParagraphs=2)
    @DiscreteRange(min=0, max=20)
    private int delayPostBridging = 4;
    @Category(value="vfx")
    @SerialEntry
    @IncludeImage(value="textures/gui/config/show_crosshair.png")
    private boolean showCrosshair = true;
    @Category(value="vfx")
    @SerialEntry
    @IncludeImage(value="textures/gui/config/bridging_outline.png")
    private boolean showOutline = false;
    @Category(value="vfx")
    @SerialEntry
    @IncludeImage(value="textures/gui/config/non_bridging_outline.png")
    private boolean showOutlineEvenWhenNotBridging = false;
    @Category(value="vfx")
    @SerialEntry
    @IncludeExtraDescription
    private boolean nonBridgeRespectsCrouchRules = true;
    @Category(value="vfx")
    @SerialEntry
    @IncludeImage(value="textures/gui/config/outline_colour.png")
    @IncludeExtraDescription
    private Color outlineColour = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    @Category(value="fixes")
    @SerialEntry
    private boolean skipTorchBridging = true;
    @Category(value="fixes")
    @SerialEntry
    @IncludeExtraDescription(extraParagraphs=3)
    private boolean enableSlabAssist = true;
    @Category(value="fixes")
    @SerialEntry
    private boolean enableNonSolidReplace = true;
    @Category(value="debug")
    @SerialEntry
    private boolean showDebugHighlight = true;
    @Category(value="debug")
    @SerialEntry
    private boolean showNonBridgingDebugHighlight = false;
    @Category(value="debug")
    @SerialEntry
    private boolean showDebugTrace = false;

    public BridgingConfig() {
        this.upgrade();
        this.saveDefaults();
    }

    public boolean isBridgingEnabled() {
        return this.enableBridgingAssist;
    }

    public boolean shouldOnlyBridgeWhenCrouched() {
        return this.onlyBridgeWhenCrouched;
    }

    public boolean isSlabAssistEnabled() {
        return this.enableSlabAssist;
    }

    public boolean isNonSolidReplaceEnabled() {
        return this.enableNonSolidReplace;
    }

    public int getDelayPostBridging() {
        return this.delayPostBridging;
    }

    public PlacementAxisMode getSupportedBridgeAxes() {
        return this.supportedBridgeAxes;
    }

    public PlacementAxisModeOverride getSupportedBridgeAxesWhenCrouched() {
        return this.supportedBridgeAxesWhenCrouched;
    }

    public boolean shouldShowCrosshair() {
        return this.showCrosshair;
    }

    public boolean shouldShowOutline() {
        return this.showOutline;
    }

    public boolean shouldShowOutlineEvenWhenNotBridging() {
        return this.showOutlineEvenWhenNotBridging;
    }

    public boolean shouldNonBridgeRespectsCrouchRules() {
        return this.nonBridgeRespectsCrouchRules;
    }

    public Color getOutlineColour() {
        return this.outlineColour;
    }

    public boolean shouldShowOutlineInF3() {
        return this.showDebugHighlight;
    }

    public boolean shouldShowNonBridgeOutlineInF3() {
        return this.showNonBridgingDebugHighlight;
    }

    public boolean shouldShowDebugTrace() {
        return this.showDebugTrace;
    }

    public boolean shouldSkipTorchBridging() {
        return this.skipTorchBridging;
    }

    public void toggleBridgingEnabled() {
        this.enableBridgingAssist = !this.isBridgingEnabled();
        HANDLER.save();
    }

    public void upgrade() {
        this.version = 3;
    }
}

