/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pane;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.pane.CornerStripSkipPredicate;

@CullTest(value={BlockType.FRAMED_WALL_BOARD})
public final class WallBoardSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (side.getAxis() != dir.getAxis()) {
            if (adjState.getBlock() == state.getBlock()) {
                return WallBoardSkipPredicate.testAgainstWallBoard(dir, adjState);
            }
            if (adjState.getBlock() == FBContent.BLOCK_FRAMED_CORNER_STRIP.value()) {
                return WallBoardSkipPredicate.testAgainstCornerStrip(dir, adjState, side);
            }
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL_BOARD})
    private static boolean testAgainstWallBoard(Direction dir, BlockState adjState) {
        return dir == adjState.getValue((Property)FramedProperties.FACING_HOR);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_STRIP})
    private static boolean testAgainstCornerStrip(Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return WallBoardSkipPredicate.getHalfDir(dir, side).isEqualTo(CornerStripSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    public static HalfDir getHalfDir(Direction dir, Direction side) {
        if (side.getAxis() != dir.getAxis()) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

