/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerTubeOrientation;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_TUBE})
public final class TubeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            boolean thick = (Boolean)state.getValue((Property)PropertyHolder.THICK);
            return switch (type) {
                case BlockType.FRAMED_TUBE -> TubeSkipPredicate.testAgainstTube(axis, thick, adjState, side);
                case BlockType.FRAMED_CORNER_TUBE -> TubeSkipPredicate.testAgainstCornerTube(axis, thick, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_TUBE})
    private static boolean testAgainstTube(Direction.Axis axis, boolean thick, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        boolean adjThick = (Boolean)adjState.getValue((Property)PropertyHolder.THICK);
        return side.getAxis() == axis && adjAxis == axis && adjThick == thick;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_TUBE})
    private static boolean testAgainstCornerTube(Direction.Axis axis, boolean thick, BlockState adjState, Direction side) {
        CornerTubeOrientation orientation = (CornerTubeOrientation)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        boolean adjThick = (Boolean)adjState.getValue((Property)PropertyHolder.THICK);
        return side.getAxis() == axis && orientation.isSideOpen(side.getOpposite()) && adjThick == thick;
    }
}

