/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class SlopedPrismShapes
implements SplitShapeGenerator {
    public static final SlopedPrismShapes OUTER = new SlopedPrismShapes();

    private SlopedPrismShapes() {
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopedPrismShapes.generate(states, SlopeShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopedPrismShapes.generate(states, SlopeShapes.OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeType> slopeShapes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape slopeShapeBottom = slopeShapes.get(SlopeType.BOTTOM);
        VoxelShape shapeBottom = ShapeUtils.andUnoptimized(slopeShapeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, slopeShapeBottom), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, slopeShapeBottom));
        VoxelShape shapeTop = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.UP, shapeBottom);
        VoxelShape shapeUp = ShapeUtils.rotateShapeUnoptimizedAroundX(Direction.UP, Direction.SOUTH, shapeTop);
        VoxelShape shapeDown = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.DOWN, shapeUp);
        VoxelShape shapeRight = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.WEST, shapeUp);
        VoxelShape shapeLeft = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.EAST, shapeUp);
        VoxelShape[] shapes = new VoxelShape[CompoundDirection.COUNT];
        for (CompoundDirection cmpDir : CompoundDirection.values()) {
            VoxelShape shape;
            Direction facing = cmpDir.direction();
            Direction orientation = cmpDir.orientation();
            if (Utils.isY(facing)) {
                shapes[cmpDir.ordinal()] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop);
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.getClockWise()) {
                shape = shapeLeft;
            } else if (orientation == facing.getCounterClockWise()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            shapes[cmpDir.ordinal()] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, facing, shape);
        }
        for (BlockState state : states) {
            CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
            builder.put((Object)state, (Object)shapes[cmpDir.ordinal()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

