/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class TubeShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape shapeThinY = ShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape shapeThinZ = ShapeUtils.rotateShapeAroundX(Direction.UP, Direction.SOUTH, shapeThinY);
        VoxelShape shapeThinX = ShapeUtils.rotateShapeAroundZ(Direction.UP, Direction.EAST, shapeThinY);
        VoxelShape shapeThickY = ShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape shapeThickZ = ShapeUtils.rotateShapeAroundX(Direction.UP, Direction.SOUTH, shapeThickY);
        VoxelShape shapeThickX = ShapeUtils.rotateShapeAroundZ(Direction.UP, Direction.EAST, shapeThickY);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean thick = (Boolean)state.getValue((Property)PropertyHolder.THICK);
            VoxelShape shape = switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (thick) {
                        yield shapeThickX;
                    }
                    yield shapeThinX;
                }
                case Direction.Axis.Y -> {
                    if (thick) {
                        yield shapeThickY;
                    }
                    yield shapeThinY;
                }
                case Direction.Axis.Z -> thick ? shapeThickZ : shapeThinZ;
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private TubeShapes() {
    }
}

