/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;

public final class FramingSawRecipeCache {
    private static final FramingSawRecipeCache SERVER_INSTANCE = new FramingSawRecipeCache();
    private static final FramingSawRecipeCache CLIENT_INSTANCE = new FramingSawRecipeCache();
    private final List<RecipeHolder<FramingSawRecipe>> recipes = new ArrayList<RecipeHolder<FramingSawRecipe>>();
    private final List<RecipeHolder<FramingSawRecipe>> recipesView = Collections.unmodifiableList(this.recipes);
    private final Map<Item, RecipeHolder<FramingSawRecipe>> recipesByResult = new IdentityHashMap<Item, RecipeHolder<FramingSawRecipe>>();
    private final Map<Item, RecipeHolder<FramingSawRecipe>> recipesWithAdditives = new IdentityHashMap<Item, RecipeHolder<FramingSawRecipe>>();
    private final Reference2IntMap<Item> materialValues = new Reference2IntOpenHashMap();

    public void update(RecipeManager recipeManager) {
        this.clear();
        this.recipes.addAll(recipeManager.getAllRecipesFor((RecipeType)FBContent.RECIPE_TYPE_FRAMING_SAW_RECIPE.value()));
        this.recipes.sort(FramingSawRecipeCache::sortRecipes);
        this.recipes.forEach(holder -> {
            FramingSawRecipe recipe = (FramingSawRecipe)holder.value();
            ItemStack result = recipe.getResult();
            int materialValue = recipe.getMaterialAmount();
            this.materialValues.put((Object)result.getItem(), materialValue / result.getCount());
        });
        this.recipes.removeIf(h -> ((FramingSawRecipe)h.value()).isDisabled());
        this.recipes.forEach(holder -> {
            FramingSawRecipe recipe = (FramingSawRecipe)holder.value();
            ItemStack result = recipe.getResult();
            this.recipesByResult.put(result.getItem(), (RecipeHolder<FramingSawRecipe>)holder);
            if (!recipe.getAdditives().isEmpty()) {
                this.recipesWithAdditives.put(result.getItem(), (RecipeHolder<FramingSawRecipe>)holder);
            }
        });
    }

    public void clear() {
        this.recipes.clear();
        this.recipesByResult.clear();
        this.recipesWithAdditives.clear();
        this.materialValues.clear();
    }

    public List<RecipeHolder<FramingSawRecipe>> getRecipes() {
        return this.recipesView;
    }

    @Nullable
    public RecipeHolder<FramingSawRecipe> findRecipeFor(ItemStack result) {
        return this.recipesByResult.get(result.getItem());
    }

    public Set<Item> getKnownItems() {
        return this.materialValues.keySet();
    }

    public int getMaterialValue(Item item) {
        return this.materialValues.getOrDefault((Object)item, -1);
    }

    public boolean containsAdditive(Item item) {
        return this.recipesWithAdditives.containsKey(item);
    }

    public List<RecipeHolder<FramingSawRecipe>> getRecipesWithAdditive(ItemStack additive) {
        return this.recipesWithAdditives.values().stream().filter(recipe -> ((FramingSawRecipe)recipe.value()).getAdditives().stream().map(FramingSawRecipeAdditive::ingredient).anyMatch(ing -> ing.test(additive))).toList();
    }

    public static FramingSawRecipeCache get(boolean client) {
        return client ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Reloader(event.getServerResources()));
    }

    private static int sortRecipes(RecipeHolder<FramingSawRecipe> holder1, RecipeHolder<FramingSawRecipe> holder2) {
        FramingSawRecipe r1 = (FramingSawRecipe)holder1.value();
        FramingSawRecipe r2 = (FramingSawRecipe)holder2.value();
        return FramingSawRecipeCache.sortRecipes(r1.getResult(), r2.getResult(), r1.getResultType(), r2.getResultType());
    }

    public static int sortRecipes(ItemStack resultOne, ItemStack resultTwo, IBlockType typeOne, IBlockType typeTwo) {
        String ns2;
        String ns1 = BuiltInRegistries.ITEM.getKey((Object)resultOne.getItem()).getNamespace();
        if (!ns1.equals(ns2 = BuiltInRegistries.ITEM.getKey((Object)resultTwo.getItem()).getNamespace())) {
            if (ns1.equals("framedblocks")) {
                return -1;
            }
            if (ns2.equals("framedblocks")) {
                return 1;
            }
            return ns1.compareTo(ns2);
        }
        return typeOne.compareTo(typeTwo);
    }

    private record Reloader(ReloadableServerResources serverResources) implements ResourceManagerReloadListener
    {
        public void onResourceManagerReload(ResourceManager resourceManager) {
            SERVER_INSTANCE.update(this.serverResources.getRecipeManager());
        }
    }
}

