/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.util.FramedUtils;

public record FramingSawRecipeAdditive(Ingredient ingredient, int count, @Nullable TagKey<Item> srcTag) {
    public static final Codec<FramingSawRecipeAdditive> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(FramingSawRecipeAdditive::ingredient), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(FramingSawRecipeAdditive::count)).apply((Applicative)inst, FramingSawRecipeAdditive::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, FramingSawRecipeAdditive> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FramingSawRecipeAdditive::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, FramingSawRecipeAdditive::count, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC).map(opt -> opt.map(ItemTags::create).orElse(null), key -> Optional.ofNullable(key).map(TagKey::location)), FramingSawRecipeAdditive::srcTag, FramingSawRecipeAdditive::new);

    public FramingSawRecipeAdditive(Ingredient ingredient, int count, @Nullable TagKey<Item> srcTag) {
        Preconditions.checkArgument((ingredient != null ? 1 : 0) != 0, (Object)"Additive ingredient must be non-null");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Additive count must be greater than 0");
    }

    public boolean isTagBased() {
        return this.srcTag != null;
    }

    public static FramingSawRecipeAdditive of(Ingredient ingredient, int count) {
        TagKey srcTag = null;
        Ingredient.Value value = FramedUtils.getSingleIngredientValue(ingredient);
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue value2 = (Ingredient.TagValue)value;
            srcTag = value2.tag();
        }
        return new FramingSawRecipeAdditive(ingredient, count, (TagKey<Item>)srcTag);
    }

    public static FramingSawRecipeAdditive of(TagKey<Item> tag) {
        return FramingSawRecipeAdditive.of(tag, 1);
    }

    public static FramingSawRecipeAdditive of(TagKey<Item> tag, int count) {
        return FramingSawRecipeAdditive.of(Ingredient.of(tag), count);
    }

    public static FramingSawRecipeAdditive of(ItemLike item) {
        return FramingSawRecipeAdditive.of(item, 1);
    }

    public static FramingSawRecipeAdditive of(ItemLike item, int count) {
        return FramingSawRecipeAdditive.of(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
    }
}

