/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.Lazy;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;

public final class FramingSawRecipe
implements Recipe<RecipeInput> {
    public static final int CUBE_MATERIAL_VALUE = 6144;
    public static final int MAX_ADDITIVE_COUNT = 3;
    private static final Lazy<ItemStack> TOAST_ICON = Lazy.of(() -> new ItemStack((ItemLike)FBContent.BLOCK_FRAMING_SAW.value()));
    private final int materialAmount;
    private final List<FramingSawRecipeAdditive> additives;
    private final ItemStack result;
    private final IBlockType resultType;
    private final boolean disabled;

    FramingSawRecipe(int materialAmount, List<FramingSawRecipeAdditive> additives, ItemStack result, boolean disabled) {
        this.materialAmount = materialAmount;
        this.additives = additives;
        this.result = result;
        this.resultType = FramingSawRecipe.findResultType(result);
        this.disabled = disabled;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.matchWithResult(recipeInput, level).success();
    }

    public FramingSawRecipeMatchResult matchWithResult(RecipeInput recipeInput, Level level) {
        ItemStack input = recipeInput.getItem(0);
        if (input.isEmpty()) {
            return FramingSawRecipeMatchResult.MATERIAL_VALUE;
        }
        if (!((CamoList)input.getOrDefault(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY)).isEmptyOrContentsEmpty()) {
            return FramingSawRecipeMatchResult.CAMO_PRESENT;
        }
        int inputValue = FramingSawRecipeCalculation.getInputValue(input, level.isClientSide());
        int totalInputValue = inputValue * input.getCount();
        if (totalInputValue < this.materialAmount) {
            return FramingSawRecipeMatchResult.MATERIAL_VALUE;
        }
        long matLcm = FramingSawRecipeCalculation.getMaterialLCM(this, inputValue);
        if (matLcm > (long)totalInputValue) {
            return FramingSawRecipeMatchResult.MATERIAL_LCM;
        }
        if (FramingSawRecipeCalculation.getOutputCount(this.materialAmount, this.result, matLcm) > this.result.getMaxStackSize()) {
            return FramingSawRecipeMatchResult.OUTPUT_SIZE;
        }
        for (int idx = 0; idx < 3; ++idx) {
            ItemStack stack = recipeInput.getItem(idx + 1);
            FramingSawRecipeAdditive additive = idx < this.additives.size() ? this.additives.get(idx) : null;
            boolean empty = stack.isEmpty();
            if (empty && additive == null) continue;
            if (!empty && additive == null) {
                return FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE[idx];
            }
            if (empty) {
                return FramingSawRecipeMatchResult.MISSING_ADDITIVE[idx];
            }
            if (!additive.ingredient().test(stack)) {
                return FramingSawRecipeMatchResult.INCORRECT_ADDITIVE[idx];
            }
            if (stack.getCount() >= FramingSawRecipeCalculation.getAdditiveCount(this, additive, matLcm)) continue;
            return FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE[idx];
        }
        return FramingSawRecipeMatchResult.SUCCESS;
    }

    public FramingSawRecipeCalculation makeCraftingCalculation(RecipeInput container, boolean client) {
        return new FramingSawRecipeCalculation(this, container, client);
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider access) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public int getMaterialAmount() {
        return this.materialAmount;
    }

    public List<FramingSawRecipeAdditive> getAdditives() {
        return this.additives;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.result;
    }

    public IBlockType getResultType() {
        return this.resultType;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return (ItemStack)TOAST_ICON.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FBContent.RECIPE_SERIALIZER_FRAMING_SAW_RECIPE.value();
    }

    public RecipeType<?> getType() {
        return (RecipeType)FBContent.RECIPE_TYPE_FRAMING_SAW_RECIPE.value();
    }

    private static IBlockType findResultType(ItemStack result) {
        Item item = result.getItem();
        if (!(item instanceof BlockItem)) {
            throw new JsonSyntaxException("Result items must be BlockItems");
        }
        BlockItem item2 = (BlockItem)item;
        Block block = item2.getBlock();
        if (!(block instanceof IFramedBlock)) {
            throw new JsonSyntaxException("Block of result items must be IFramedBlocks");
        }
        IFramedBlock block2 = (IFramedBlock)block;
        return block2.getBlockType();
    }
}

