/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.capability.TankFluidHandler;

public class FramedTankBlockEntity
extends FramedBlockEntity {
    private final TankFluidHandler fluidHandler = new TankFluidHandler(this);

    public FramedTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_TANK.value(), pos, state);
    }

    public ItemInteractionResult handleTankInteraction(Player player, InteractionHand hand) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidHandler)) {
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public FluidStack getContents() {
        return this.fluidHandler.getFluid();
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public void onTankContentsChanged() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.setChanged();
        if (!((Boolean)this.getBlockState().getValue((Property)FramedProperties.SOLID)).booleanValue()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getAnalogSignal() {
        return this.fluidHandler.getFluid().getAmount() * 15 / 16000;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.fluidHandler.save(tag, provider);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        this.fluidHandler.load(nbt, provider);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeToDataPacket(nbt, provider);
        this.fluidHandler.save(nbt, provider);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider provider) {
        this.fluidHandler.load(nbt, provider);
        return super.readFromDataPacket(nbt, provider);
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        FluidStack contents = ((SimpleFluidContent)input.getOrDefault(FBContent.DC_TYPE_TANK_CONTENTS, (Object)SimpleFluidContent.EMPTY)).copy();
        if (!contents.isEmpty()) {
            this.fluidHandler.setFluid(contents);
        }
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        FluidStack contents = this.fluidHandler.getFluid();
        if (!contents.isEmpty()) {
            builder.set(FBContent.DC_TYPE_TANK_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)contents));
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.fluidHandler.load(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        this.fluidHandler.save(nbt, provider);
    }
}

