/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedElevatedDoublePrismBlockEntity
extends FramedDoubleBlockEntity {
    public FramedElevatedDoublePrismBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FBContent.BE_TYPE_FRAMED_ELEVATED_DOUBLE_PRISM.value(), pos, state);
    }

    protected FramedElevatedDoublePrismBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction facing;
        Direction side = hit.getDirection();
        if (side == (facing = this.getFacing(this.getBlockState()))) {
            return true;
        }
        if (side == facing.getOpposite()) {
            return false;
        }
        if (!this.isDoubleSide(side) && side.getAxis() != facing.getAxis()) {
            return false;
        }
        if (this.isDoubleSide(side)) {
            Direction horDir = side.getClockWise(facing.getAxis());
            double hor = Utils.fractionInDir(hit.getLocation(), horDir);
            hor = Math.abs(hor - 0.5);
            double vert = Utils.fractionInDir(hit.getLocation(), facing) - 0.5;
            return vert > hor;
        }
        return false;
    }

    protected boolean isDoubleSide(Direction side) {
        return side.getAxis() == ((DirectionAxis)((Object)this.getBlockState().getValue(PropertyHolder.FACING_AXIS))).axis();
    }

    protected Direction getFacing(BlockState state) {
        return ((DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS))).direction();
    }
}

