/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedInverseDoubleSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public FramedInverseDoubleSlopePanelBlock() {
        super(BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withCrossOrSideRotation().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double xz;
        Direction face = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (face == rotation.withFacing(dir)) {
            double xz2 = Utils.fractionInDir(hit.getLocation(), dir.getOpposite());
            if (xz2 > 0.5) {
                face = dir.getOpposite();
            }
        } else if (face == rotation.withFacing(dir).getOpposite() && (xz = Utils.fractionInDir(hit.getLocation(), dir)) > 0.5) {
            face = dir;
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLOPE_PANEL.value()).defaultBlockState();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)(rotation.isVertical() ? rotation.getOpposite() : rotation)))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(true))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        Direction rotation = ((HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).withFacing(facing);
        if (side == rotation && edge == facing) {
            return CamoGetter.FIRST;
        }
        if (side == rotation.getOpposite() && edge == facing.getOpposite()) {
            return CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

