/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedHalfSlopeBlock
extends FramedBlock {
    public FramedHalfSlopeBlock() {
        super(BlockType.FRAMED_HALF_SLOPE);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.RIGHT, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withTop()).withRight().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == facing.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(facing));
        }
        if (face == facing) {
            return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
        }
        return (BlockState)state.cycle((Property)FramedProperties.TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite());
        }
        return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockItem createBlockItem() {
        return new VerticalAndWallBlockItem(this, (Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value(), new Item.Properties());
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

