/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.block.sign.FramedStandingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;

public class FramedSignRenderer
implements BlockEntityRenderer<FramedSignBlockEntity> {
    private static final float RENDER_SCALE = 0.6666667f;
    private static final Vector3f TEXT_OFFSET = new Vector3f(0.0f, 0.35f, 0.064f);
    private static final Vector3f WALL_TEXT_OFFSET = new Vector3f(0.0f, 0.334375f, 0.064f);
    private final Font font;

    public FramedSignRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.getFont();
    }

    public void render(FramedSignBlockEntity sign, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = sign.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof AbstractFramedSignBlock)) {
            return;
        }
        AbstractFramedSignBlock signBlock = (AbstractFramedSignBlock)block;
        BlockPos pos = sign.getBlockPos();
        int lineHeight = signBlock.getTextLineHeight();
        int lineWidth = signBlock.getMaxTextLineWidth();
        poseStack.pushPose();
        this.applyTransforms(poseStack, -signBlock.getYRotationDegrees(state), state);
        this.renderText(pos, signBlock, sign.getText(true), poseStack, buffer, light, lineHeight, lineWidth, true);
        this.renderText(pos, signBlock, sign.getText(false), poseStack, buffer, light, lineHeight, lineWidth, false);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(FramedSignBlockEntity blockEntity) {
        if (blockEntity.getBlockState().getBlock() instanceof FramedStandingSignBlock) {
            BlockPos pos = blockEntity.getBlockPos();
            return new AABB((double)pos.getX(), (double)pos.getY() + 0.625, (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.125, (double)pos.getZ() + 1.0);
        }
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }

    protected void applyTransforms(PoseStack poseStack, float yRot, BlockState state) {
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        if (!(state.getBlock() instanceof FramedStandingSignBlock)) {
            poseStack.translate(0.0f, -0.3125f, -0.4375f);
        }
    }

    private void applyTextTransforms(PoseStack poseStack, AbstractFramedSignBlock signBlock, boolean front) {
        if (!front) {
            poseStack.mulPose(Quaternions.YP_180);
        }
        Vector3f offset = this.getTextOffset(signBlock);
        poseStack.translate(offset.x, offset.y, offset.z);
        float scale = 0.015625f * this.getSignTextRenderScale();
        poseStack.scale(scale, -scale, scale);
    }

    protected float getSignTextRenderScale() {
        return 0.6666667f;
    }

    protected Vector3f getTextOffset(AbstractFramedSignBlock signBlock) {
        boolean standing = signBlock instanceof FramedStandingSignBlock;
        return standing ? TEXT_OFFSET : WALL_TEXT_OFFSET;
    }

    private void renderText(BlockPos pos, AbstractFramedSignBlock signBlock, SignText text, PoseStack poseStack, MultiBufferSource buffer, int light, int lineHeight, int lineWidth, boolean front) {
        int textLight;
        boolean outline;
        int textColor;
        poseStack.pushPose();
        this.applyTextTransforms(poseStack, signBlock, front);
        int darkColor = SignRenderer.getDarkColor((SignText)text);
        if (text.hasGlowingText()) {
            textColor = text.getColor().getTextColor();
            outline = SignRenderer.isOutlineVisible((BlockPos)pos, (int)textColor);
            textLight = 0xF000F0;
        } else {
            textColor = darkColor;
            outline = false;
            textLight = light;
        }
        boolean filter = Minecraft.getInstance().isTextFilteringEnabled();
        FormattedCharSequence[] lines = text.getRenderMessages(filter, line -> {
            List parts = this.font.split((FormattedText)line, lineWidth);
            return parts.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)parts.getFirst();
        });
        int centerY = 4 * lineHeight / 2;
        Matrix4f pose = poseStack.last().pose();
        for (int idx = 0; idx < 4; ++idx) {
            FormattedCharSequence line2 = lines[idx];
            float textX = (float)(-this.font.width(line2)) / 2.0f;
            float textY = idx * lineHeight - centerY;
            if (outline) {
                this.font.drawInBatch8xOutline(line2, textX, textY, textColor, darkColor, pose, buffer, textLight);
                continue;
            }
            this.font.drawInBatch(line2, textX, textY, textColor, false, pose, buffer, Font.DisplayMode.POLYGON_OFFSET, 0, textLight);
        }
        poseStack.popPose();
    }
}

