/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;

public class FramedVerticalHalfSlopeGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedVerticalHalfSlopeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (!this.ySlope && quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && quadDir == this.dir.getClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            boolean needOffset = this.top == (quadDir == Direction.DOWN);
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.0f, 0.0f)).applyIf(Modifiers.setPosition(0.5f), needOffset).export(quadMap.get(needOffset ? null : quadDir));
        } else if (quadDir == this.dir || quadDir == this.dir.getCounterClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

