/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.client;

import appeng.api.util.AEColor;
import appeng.client.render.ColorableBlockEntityBlockColor;
import appeng.client.render.StaticItemColor;
import appeng.core.network.serverbound.PartLeftClickPacket;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.monitor.ConversionMonitorBlockEntity;
import gripe._90.fulleng.client.MonitorBERenderer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod(value="fulleng", dist={Dist.CLIENT})
public class FullBlockEnergisticsClient {
    public FullBlockEnergisticsClient(IEventBus eventBus) {
        eventBus.addListener(event -> {
            BlockEntityRenderers.register(FullblockEnergistics.STORAGE_MONITOR_BE.get(), MonitorBERenderer::new);
            BlockEntityRenderers.register(FullblockEnergistics.CONVERSION_MONITOR_BE.get(), MonitorBERenderer::new);
        });
        eventBus.addListener(event -> {
            for (DeferredHolder block : FullblockEnergistics.BLOCKS.getEntries()) {
                event.register((BlockColor)ColorableBlockEntityBlockColor.INSTANCE, new Block[]{(Block)block.get()});
            }
        });
        eventBus.addListener(event -> {
            for (DeferredHolder block : FullblockEnergistics.BLOCKS.getEntries()) {
                event.register((ItemColor)new StaticItemColor(AEColor.TRANSPARENT), new ItemLike[]{(ItemLike)block.get()});
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            Level level = event.getLevel();
            if (level.isClientSide()) {
                HitResult patt0$temp = Minecraft.getInstance().hitResult;
                if (!(patt0$temp instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult hitResult = (BlockHitResult)patt0$temp;
                BlockEntity patt1$temp = level.getBlockEntity(hitResult.getBlockPos());
                if (patt1$temp instanceof ConversionMonitorBlockEntity) {
                    ConversionMonitorBlockEntity monitor = (ConversionMonitorBlockEntity)patt1$temp;
                    if (hitResult.getDirection() == monitor.getFront()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new PartLeftClickPacket(hitResult, event.getEntity().isShiftKeyDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        Objects.requireNonNull(Minecraft.getInstance().gameMode).destroyDelay = 5;
                        event.setCanceled(true);
                    }
                }
            }
        });
    }
}

