/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.terminal;

import appeng.helpers.IPatternTerminalLogicHost;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.inv.AppEngInternalInventory;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.terminal.StorageTerminalBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PatternEncodingTerminalBlockEntity
extends StorageTerminalBlockEntity
implements IPatternTerminalLogicHost,
IPatternTerminalMenuHost {
    private final PatternEncodingLogic logic = new PatternEncodingLogic((IPatternTerminalLogicHost)this);

    public PatternEncodingTerminalBlockEntity(BlockPos pos, BlockState blockState) {
        super(FullblockEnergistics.PATTERN_ENCODING_TERMINAL_BE.get(), pos, blockState);
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        this.logic.getBlankPatternInv().forEach(drops::add);
        this.logic.getEncodedPatternInv().forEach(drops::add);
    }

    @Override
    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.logic.readFromNBT(data, registries);
    }

    @Override
    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.logic.writeToNBT(data, registries);
    }

    @Override
    public MenuType<?> getMenuType() {
        return PatternEncodingTermMenu.TYPE;
    }

    public PatternEncodingLogic getLogic() {
        return this.logic;
    }

    public Level getLevel() {
        return this.level;
    }

    public void markForSave() {
        this.saveChanges();
        this.markForUpdate();
    }

    @Override
    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.saveChanges();
        this.markForUpdate();
    }
}

