/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.monitor;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.crafting.ICraftingWatcherNode;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.api.util.INetworkToolAware;
import appeng.core.localization.PlayerMessages;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.FullBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class StorageMonitorBlockEntity
extends FullBlockEntity
implements INetworkToolAware {
    @Nullable
    private AEKey configuredItem;
    private long amount;
    private boolean canCraft;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher storageWatcher;
    private IStackWatcher craftingWatcher;

    public StorageMonitorBlockEntity(BlockPos pos, BlockState state) {
        this(FullblockEnergistics.STORAGE_MONITOR_BE.get(), pos, state);
    }

    public StorageMonitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.getMainNode().addService(IStorageWatcherNode.class, (IGridNodeService)new IStorageWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                StorageMonitorBlockEntity.this.storageWatcher = newWatcher;
                StorageMonitorBlockEntity.this.configureWatchers();
            }

            public void onStackChange(AEKey what, long amount) {
                if (what.equals(StorageMonitorBlockEntity.this.configuredItem)) {
                    String humanReadableText;
                    StorageMonitorBlockEntity.this.amount = amount;
                    String string = humanReadableText = amount == 0L && StorageMonitorBlockEntity.this.canCraft ? "Craft" : what.formatAmount(amount, AmountFormat.SLOT);
                    if (!humanReadableText.equals(StorageMonitorBlockEntity.this.lastHumanReadableText)) {
                        StorageMonitorBlockEntity.this.lastHumanReadableText = humanReadableText;
                        StorageMonitorBlockEntity.this.saveChanges();
                        StorageMonitorBlockEntity.this.markForUpdate();
                    }
                }
            }
        });
        this.getMainNode().addService(ICraftingWatcherNode.class, (IGridNodeService)new ICraftingWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                StorageMonitorBlockEntity.this.craftingWatcher = newWatcher;
                StorageMonitorBlockEntity.this.configureWatchers();
            }

            public void onRequestChange(AEKey what) {
            }

            public void onCraftableChange(AEKey what) {
                StorageMonitorBlockEntity.this.getMainNode().ifPresent(StorageMonitorBlockEntity.this::updateReportingValue);
            }
        });
    }

    @Override
    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean wasLocked;
        boolean needRedraw = super.readFromStream(data);
        this.isLocked = wasLocked = data.readBoolean();
        if (data.readBoolean()) {
            this.configuredItem = AEKey.readKey((RegistryFriendlyByteBuf)data);
            this.amount = data.readVarLong();
            this.canCraft = data.readBoolean();
        } else {
            this.configuredItem = null;
            this.amount = 0L;
            this.canCraft = false;
        }
        return wasLocked != this.isLocked || needRedraw;
    }

    @Override
    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            AEKey.writeKey((RegistryFriendlyByteBuf)data, (AEKey)this.configuredItem);
            data.writeVarLong(this.amount);
            data.writeBoolean(this.canCraft);
        }
    }

    @Override
    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.putLong("amount", this.amount);
        data.putBoolean("canCraft", this.canCraft);
    }

    @Override
    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.amount = data.getLong("amount");
        this.canCraft = data.getBoolean("canCraft");
    }

    @Override
    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putBoolean("isLocked", this.isLocked);
        if (this.configuredItem != null) {
            data.put("configuredItem", (Tag)this.configuredItem.toTagGeneric(registries));
        }
    }

    @Override
    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.isLocked = data.getBoolean("isLocked");
        this.configuredItem = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)data.getCompound("configuredItem"));
    }

    public void onActivated(Player player, InteractionHand hand) {
        if (!this.isLocked) {
            ItemStack eq = player.getItemInHand(hand);
            if (AEItemKey.matches((AEKey)this.configuredItem, (ItemStack)eq)) {
                GenericStack containedStack = ContainerItemStrategies.getContainedStack((ItemStack)eq);
                if (containedStack != null) {
                    this.configuredItem = containedStack.what();
                }
            } else {
                this.configuredItem = AEItemKey.of((ItemStack)eq);
            }
            this.configureWatchers();
            this.saveChanges();
            this.markForUpdate();
        }
    }

    public void onShiftActivated(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).isEmpty()) {
            this.isLocked = !this.isLocked;
            player.sendSystemMessage((Component)(this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).text());
            this.saveChanges();
            this.markForUpdate();
        }
    }

    private void configureWatchers() {
        if (this.storageWatcher != null) {
            this.storageWatcher.reset();
        }
        if (this.craftingWatcher != null) {
            this.craftingWatcher.reset();
        }
        if (this.configuredItem != null) {
            if (this.storageWatcher != null) {
                this.storageWatcher.add(this.configuredItem);
            }
            if (this.craftingWatcher != null) {
                this.craftingWatcher.add(this.configuredItem);
            }
            this.getMainNode().ifPresent(this::updateReportingValue);
        }
    }

    private void updateReportingValue(IGrid grid) {
        this.lastHumanReadableText = null;
        if (this.configuredItem != null) {
            this.amount = grid.getStorageService().getCachedInventory().get(this.configuredItem);
            this.canCraft = grid.getCraftingService().isCraftable(this.configuredItem);
        } else {
            this.amount = 0L;
            this.canCraft = false;
        }
        this.markForUpdate();
    }

    public AEKey getDisplayed() {
        return this.configuredItem;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean canCraft() {
        return this.canCraft;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean showNetworkInfo(UseOnContext context) {
        return context.getClickedFace() != this.getFront();
    }
}

