/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.monitor;

import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ISubMenuHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.me.helpers.PlayerSource;
import appeng.menu.ISubMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import appeng.util.inv.PlayerInternalInventory;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.monitor.StorageMonitorBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ConversionMonitorBlockEntity
extends StorageMonitorBlockEntity
implements ISubMenuHost {
    public ConversionMonitorBlockEntity(BlockPos pos, BlockState state) {
        super(FullblockEnergistics.CONVERSION_MONITOR_BE.get(), pos, state);
    }

    @Override
    public void onActivated(Player player, InteractionHand hand) {
        ItemStack holding = player.getItemInHand(hand);
        if (this.isLocked()) {
            this.insertItem(player, hand, holding.isEmpty());
        } else if (this.getDisplayed() != null && AEItemKey.matches((AEKey)this.getDisplayed(), (ItemStack)holding)) {
            this.insertItem(player, hand, false);
        } else {
            super.onActivated(player, hand);
        }
    }

    private void insertItem(Player player, InteractionHand hand, boolean allItems) {
        this.getMainNode().ifPresent(grid -> {
            IEnergyService energy = grid.getEnergyService();
            MEStorage storage = grid.getStorageService().getInventory();
            if (allItems) {
                AEKey patt0$temp = this.getDisplayed();
                if (patt0$temp instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)patt0$temp;
                    PlayerInternalInventory inv = new PlayerInternalInventory(player.getInventory());
                    for (int x = 0; x < inv.size(); ++x) {
                        ItemStack canExtract;
                        ItemStack targetStack = inv.getStackInSlot(x);
                        if (!itemKey.matches(targetStack) || (canExtract = inv.extractItem(x, targetStack.getCount(), true)).isEmpty()) continue;
                        long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)storage, (AEKey)itemKey, (long)canExtract.getCount(), (IActionSource)new PlayerSource(player, (IActionHost)this));
                        inv.extractItem(x, (int)inserted, false);
                    }
                }
            } else {
                ItemStack input = player.getItemInHand(hand);
                if (!input.isEmpty()) {
                    long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)storage, (AEKey)((AEKey)Objects.requireNonNull(AEItemKey.of((ItemStack)input))), (long)input.getCount(), (IActionSource)new PlayerSource(player, (IActionHost)this));
                    input.shrink((int)inserted);
                }
            }
        });
    }

    public void extractItem(Player player, boolean shift) {
        AEKey aEKey = this.getDisplayed();
        if (!(aEKey instanceof AEItemKey)) {
            return;
        }
        AEItemKey item = (AEItemKey)aEKey;
        if (!this.getMainNode().isActive()) {
            return;
        }
        if (this.getAmount() == 0L && this.canCraft()) {
            CraftAmountMenu.open((ServerPlayer)((ServerPlayer)player), (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this), (AEKey)item, (int)item.getAmountPerUnit());
            return;
        }
        this.getMainNode().ifPresent(grid -> {
            int count = shift ? 1 : item.getMaxStackSize();
            long retrieved = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)item, (long)count, (IActionSource)new PlayerSource(player, (IActionHost)this));
            if (retrieved != 0L) {
                ItemStack newItems = item.toStack((int)retrieved);
                if (!player.getInventory().add(newItems)) {
                    player.drop(newItems, false);
                }
                player.containerMenu.broadcastChanges();
            }
        });
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        player.closeContainer();
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getItemFromBlockEntity());
    }
}

