/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.core.definitions.AEItems;
import gripe._90.fulleng.block.entity.FullBlockEntity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public abstract class FullBlock<F extends FullBlockEntity>
extends AEBaseEntityBlock<F> {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    private final ItemLike equivalentPart;

    public FullBlock(ItemLike equivalentPart) {
        super(BlockBehaviour.Properties.of().strength(2.2f, 11.0f).mapColor(MapColor.METAL).sound(SoundType.METAL).lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 9 : 0));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.equivalentPart = equivalentPart;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, F be) {
        return (BlockState)super.updateBlockStateFromBlockEntity(currentState, be).setValue((Property)POWERED, (Comparable)Boolean.valueOf(((FullBlockEntity)((Object)be)).isActive()));
    }

    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.full();
    }

    public ItemLike getEquivalentPart() {
        return this.equivalentPart;
    }

    public boolean shouldShowInCreative() {
        return this.equivalentPart != AEItems.MISSING_CONTENT;
    }

    @NotNull
    public String getDescriptionId() {
        return this.equivalentPart.asItem().getDescriptionId();
    }
}

