/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.LimitedSlot;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceLimits;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class OutputStatement
implements IOStatement {
    private final LabelAccess labelAccess;
    private final ResourceLimits resourceLimits;
    private final boolean each;
    private int lastInputCapacity = 32;
    private int lastOutputCapacity = 32;

    public OutputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) {
        this.labelAccess = labelAccess;
        this.resourceLimits = resourceLimits;
        this.each = each;
    }

    public static <STACK, ITEM, CAP> void moveTo(ProgramContext context, LimitedInputSlot<STACK, ITEM, CAP> source, LimitedOutputSlot<STACK, ITEM, CAP> destination) {
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_BEGIN.get(source, destination)));
        if (!source.type.equals(destination.type)) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_TYPE_MISMATCH.get()));
            return;
        }
        ResourceType resourceType = source.type;
        Object potential = source.peekExtractPotential();
        if (!destination.tracker.matchesStack(potential)) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_DESTINATION_TRACKER_REJECT.get()));
            return;
        }
        Object potentialRemainder = destination.insert(potential, true);
        long toMove = source.type.getAmountDifference(potential, potentialRemainder);
        if (toMove <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_ZERO_SIMULATED_MOVEMENT.get(potentialRemainder, potential)));
            return;
        }
        long promised_to_leave_in_this_slot = source.tracker.getRetentionObligationForSlot(resourceType, potential, source.pos, source.slot);
        long remainingObligation = source.tracker.getRemainingRetentionObligation(resourceType, potential);
        remainingObligation = Long.min(toMove -= promised_to_leave_in_this_slot, remainingObligation);
        toMove -= remainingObligation;
        if (remainingObligation > 0L) {
            source.tracker.trackRetentionObligation(resourceType, potential, source.slot, source.pos, remainingObligation);
        }
        long logRemainingObligation = remainingObligation;
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_RETENTION_OBLIGATION.get(promised_to_leave_in_this_slot, logRemainingObligation)));
        if (toMove <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_RETENTION_OBLIGATION_NO_MOVE.get()));
            source.setDone();
            return;
        }
        long destinationMaxTransferable = destination.tracker.getMaxTransferable(resourceType, potential);
        toMove = Math.min(toMove, destinationMaxTransferable);
        long sourceMaxTransferable = source.tracker.getMaxTransferable(resourceType, potential);
        toMove = Math.min(toMove, sourceMaxTransferable);
        long maxStackSize = resourceType.getMaxStackSize(potential);
        long logToMove = toMove = Math.min(toMove, maxStackSize);
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_STACK_LIMIT_NEW_TO_MOVE.get(destinationMaxTransferable, sourceMaxTransferable, maxStackSize, logToMove)));
        if (toMove <= 0L) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_ZERO_TO_MOVE.get()));
            return;
        }
        Object extracted = source.extract(toMove);
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_EXTRACTED.get(extracted, source)));
        STACK extractedRemainder = destination.insert(extracted, false);
        long moved = resourceType.getAmountDifference(extracted, extractedRemainder);
        source.tracker.trackTransfer(resourceType, extracted, moved);
        destination.tracker.trackTransfer(resourceType, extracted, moved);
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_MOVE_TO_END.get(moved, destination.type.getRegistryKey(extracted), source, destination)));
        if (!destination.type.isEmpty(extractedRemainder)) {
            ResourceLocation resourceTypeName = SFMResourceTypes.DEFERRED_TYPES.getKey(source.type);
            String stackName = destination.type.getItem(potential).toString();
            Level level = context.getManager().getLevel();
            assert (level != null);
            StringBuilder report = new StringBuilder();
            report.append("!!!RESOURCE LOSS HAS OCCURRED!!!");
            String currentLine = Thread.currentThread().getStackTrace()[1].toString();
            report.append("    ").append(currentLine).append("\n");
            report.append("=== Summary ===\n");
            int width = -32;
            report.append(String.format("%" + width + "s", "Simulated extraction")).append(": ").append(potential).append("\n");
            report.append(String.format("%" + width + "s", "Simulated insertion remainder")).append(": ").append(potentialRemainder).append(" (moved=").append(resourceType.getAmountDifference(potential, potentialRemainder)).append(")").append(" <-- the output block lied here\n");
            report.append(String.format("%" + width + "s", "Actual extraction")).append(": ").append(extracted).append("\n");
            report.append(String.format("%" + width + "s", "Actual insertion")).append(": ").append(moved).append(" ").append(stackName).append("\n");
            report.append(String.format("%" + width + "s", "Actual insertion remainder")).append(": ").append(extractedRemainder).append(" (").append(resourceTypeName).append(":").append(stackName).append(") <-- this is what was lost\n");
            report.append("=== Manager ===\n");
            report.append("Level: ").append(level.dimension().location()).append(" (").append(level).append(")\n");
            report.append("Position: ").append(context.getManager().getBlockPos()).append("\n");
            report.append("=== Input Slot ===\n");
            OutputStatement.addSlotDetailsToReport(report, source, level);
            report.append("=== Output Slot ===\n");
            OutputStatement.addSlotDetailsToReport(report, destination, level);
            context.getLogger().error(x -> x.accept(LocalizationKeys.LOG_PROGRAM_VOIDED_RESOURCES.get(report.toString())));
            if (((Boolean)SFMConfig.SERVER.logResourceLossToConsole.get()).booleanValue()) {
                report.append("\nThis can be silenced in the SFM config.\n");
                report.append("Operators can use `/sfm config edit` to open a GUI to change the SFM config while the game is running.\n");
                report.append("This can be caused by output inventory logic encountering an integer overflow when moving large quantities of items.\n");
                report.append("The SFM issue tracker can be found at ").append("https://github.com/TeamDman/SuperFactoryManager/issues").append(" because this shouldn't be happening lol");
                SFM.LOGGER.error(report.toString());
            }
        }
    }

    private static <STACK, ITEM, CAP> void addSlotDetailsToReport(StringBuilder report, LimitedSlot<STACK, ITEM, CAP> slot, Level level) {
        report.append("Slot: ").append(slot.getSlot()).append("\n");
        report.append("Position: ").append(slot.getPos()).append("\n");
        report.append("Direction: ").append(slot.getDirection()).append("\n");
        report.append("Capability: ").append(slot.getHandler()).append(" (").append(slot.getHandler().getClass().getName()).append(")\n");
        BlockEntity inputBlockEntity = level.getBlockEntity(slot.getPos());
        if (inputBlockEntity != null) {
            ResourceLocation inputBlockEntityType = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)inputBlockEntity.getType());
            report.append("Block Entity: ").append(inputBlockEntity.getClass().getName()).append(" (").append(inputBlockEntityType).append(")\n");
        } else {
            report.append("Block Entity: null\n");
        }
        BlockState blockState = level.getBlockState(slot.getPos());
        ResourceLocation blockType = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
        report.append("Block: ").append(blockState.getBlock().getClass().getName()).append(" (").append(blockType).append(")\n");
        report.append("Block State: ").append(blockState).append("\n");
    }

    @Override
    public void tick(ProgramContext context) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT.get(this.toString())));
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour behaviour = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            behaviour.onOutputStatementExecution(context, this);
            return;
        }
        ArrayDeque inputSlots = new ArrayDeque(this.lastInputCapacity + 27);
        for (InputStatement inputStatement : context.getInputs()) {
            inputStatement.gatherSlots(context, inputSlots::add);
        }
        this.lastInputCapacity = inputSlots.size();
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_DISCOVERED_INPUT_SLOT_COUNT.get(inputSlots.size())));
        if (inputSlots.isEmpty()) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_SHORT_CIRCUIT_NO_INPUT_SLOTS.get()));
            return;
        }
        ArrayDeque<LimitedOutputSlot> outputSlots = new ArrayDeque<LimitedOutputSlot>(this.lastOutputCapacity + 27);
        this.gatherSlots(context, outputSlots::add);
        this.lastOutputCapacity = outputSlots.size();
        context.getLogger().info(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_DISCOVERED_OUTPUT_SLOT_COUNT.get(outputSlots.size())));
        if (outputSlots.isEmpty()) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_OUTPUT_STATEMENT_SHORT_CIRCUIT_NO_OUTPUT_SLOTS.get()));
            LimitedOutputSlotObjectPool.release(outputSlots);
            return;
        }
        for (LimitedInputSlot inputSlot : inputSlots) {
            if (inputSlot.isDone()) continue;
            Iterator<LimitedOutputSlot> outputSlotIter = outputSlots.iterator();
            while (outputSlotIter.hasNext()) {
                LimitedOutputSlot outputSlot = outputSlotIter.next();
                if (outputSlot.isDone()) {
                    outputSlotIter.remove();
                    LimitedOutputSlotObjectPool.release(outputSlot);
                    continue;
                }
                OutputStatement.moveTo(context, inputSlot, outputSlot);
                if (!inputSlot.isDone()) continue;
                break;
            }
            if (!outputSlots.isEmpty()) continue;
            break;
        }
        LimitedOutputSlotObjectPool.release(outputSlots);
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedOutputSlot<?, ?, ?>> slotConsumer) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS.get(this.toStringPretty())));
        if (!this.each) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_NOT_EACH.get()));
            List<IOutputResourceTracker> outputTracker = this.resourceLimits.createOutputTrackers();
            for (ResourceType<?, ?, ?> resourceType : this.resourceLimits.getReferencedResourceTypes()) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(resourceType.displayAsCapabilityClass(), resourceType.displayAsCapabilityClass())));
                resourceType.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> this.gatherSlotsForCap(context, resourceType, label, pos, direction, cap, outputTracker, slotConsumer));
            }
        } else {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_EACH.get()));
            for (ResourceType<?, ?, ?> resourceType : this.resourceLimits.getReferencedResourceTypes()) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(resourceType.displayAsCapabilityClass(), resourceType.displayAsCapabilityClass())));
                resourceType.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> {
                    List<IOutputResourceTracker> outputTracker = this.resourceLimits.createOutputTrackers();
                    this.gatherSlotsForCap(context, resourceType, label, pos, direction, cap, outputTracker, slotConsumer);
                });
            }
        }
    }

    @Override
    public LabelAccess labelAccess() {
        return this.labelAccess;
    }

    @Override
    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    @Override
    public boolean each() {
        return this.each;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OutputStatement that = (OutputStatement)obj;
        return Objects.equals(this.labelAccess, that.labelAccess) && Objects.equals(this.resourceLimits, that.resourceLimits) && this.each == that.each;
    }

    public int hashCode() {
        return Objects.hash(this.labelAccess, this.resourceLimits, this.each);
    }

    public String toString() {
        return "OUTPUT " + this.resourceLimits.toStringCondensed(Limit.MAX_QUANTITY_MAX_RETENTION) + " TO " + (this.each ? "EACH " : "") + String.valueOf(this.labelAccess);
    }

    @Override
    public String toStringPretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("OUTPUT");
        String rls = this.resourceLimits.toStringCondensed(Limit.MAX_QUANTITY_MAX_RETENTION);
        if (rls.lines().count() > 1L) {
            sb.append("\n");
            sb.append(rls.lines().map(s -> "  " + s).collect(Collectors.joining("\n")));
            sb.append("\n");
        } else if (!rls.isEmpty()) {
            sb.append(" ");
            sb.append(rls);
            sb.append(" ");
        } else {
            sb.append(" ");
        }
        sb.append("TO ");
        sb.append(this.each ? "EACH " : "");
        sb.append(this.labelAccess);
        return sb.toString();
    }

    private <STACK, ITEM, CAP> void gatherSlotsForCap(ProgramContext context, ResourceType<STACK, ITEM, CAP> type, Label label, @Stored BlockPos pos, Direction direction, CAP capability, List<IOutputResourceTracker> trackers, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_RANGE.get(this.labelAccess.slots())));
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            int finalSlot = slot;
            if (this.labelAccess.slots().contains(slot)) {
                Object stack = type.getStackInSlot(capability, slot);
                boolean shouldCreateSlot = this.shouldCreateSlot(type, capability, stack, slot);
                for (IOutputResourceTracker tracker : trackers) {
                    if (!tracker.matchesCapabilityType(capability)) continue;
                    tracker.updateRetentionObservation(type, stack);
                    if (shouldCreateSlot) {
                        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_CREATED.get(finalSlot, stack, tracker.toString())));
                        acceptor.accept(LimitedOutputSlotObjectPool.acquire(label, pos, direction, slot, capability, tracker, stack, type));
                        continue;
                    }
                    context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_SHOULD_NOT_CREATE.get(finalSlot, type.getAmount(stack) + " of " + Math.min(type.getMaxStackSize(stack), type.getMaxStackSizeForSlot(capability, finalSlot)) + " " + String.valueOf(type.getItem(stack)))));
                }
                continue;
            }
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_NOT_IN_RANGE.get(finalSlot)));
        }
    }

    private <STACK, ITEM, CAP> boolean shouldCreateSlot(ResourceType<STACK, ITEM, CAP> type, CAP cap, STACK stack, int slot) {
        long amount = type.getAmount(stack);
        long maxStackSizeForSlot = type.getMaxStackSizeForSlot(cap, slot);
        if (maxStackSizeForSlot > 99L) {
            return amount < maxStackSizeForSlot;
        }
        if (amount >= maxStackSizeForSlot) {
            return false;
        }
        long maxStackSizeForStack = type.getMaxStackSize(stack);
        return amount < maxStackSizeForStack;
    }
}

