/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class SFMDirections {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction[] DIRECTIONS_WITH_NULL = new Direction[]{null, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN};

    public record NullableDirectionEnumMap<T>(T[] buckets) {
        public NullableDirectionEnumMap() {
            this(new Object[DIRECTIONS_WITH_NULL.length]);
        }

        public boolean containsKey(@Nullable Direction direction) {
            return this.buckets[this.keyFor(direction)] != null;
        }

        public void forEach(BiConsumer<Direction, T> callback) {
            for (Direction direction : DIRECTIONS_WITH_NULL) {
                T value = this.buckets[this.keyFor(direction)];
                if (value == null) continue;
                callback.accept(direction, (Direction)value);
            }
        }

        public void remove(@Nullable Direction direction) {
            this.buckets[this.keyFor((Direction)direction)] = null;
        }

        public boolean isEmpty() {
            for (T bucket : this.buckets) {
                if (bucket == null) continue;
                return false;
            }
            return true;
        }

        public void put(@Nullable Direction direction, T value) {
            this.buckets[this.keyFor((Direction)direction)] = value;
        }

        @Nullable
        public T get(@Nullable Direction direction) {
            return this.buckets[this.keyFor(direction)];
        }

        public int size() {
            int count = 0;
            for (T bucket : this.buckets) {
                if (bucket == null) continue;
                ++count;
            }
            return count;
        }

        private int keyFor(@Nullable Direction direction) {
            return direction == null ? 0 : direction.ordinal() + 1;
        }
    }

    public static class SingleNullDirectionIterator
    implements Iterator<Direction> {
        private boolean hasNext = true;

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public Direction next() {
            if (this.hasNext) {
                this.hasNext = false;
                return null;
            }
            throw new NoSuchElementException();
        }
    }

    public static class NullableDirectionIterator
    implements Iterator<Direction> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < DIRECTIONS_WITH_NULL.length;
        }

        @Override
        @Nullable
        public Direction next() {
            if (this.hasNext()) {
                return DIRECTIONS_WITH_NULL[this.index++];
            }
            throw new NoSuchElementException();
        }
    }
}

