/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import ca.teamdman.sfml.ast.With;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SFMASTUtils {
    public static <STACK, ITEM, CAP> Optional<InputStatement> getInputStatementForSlot(LimitedInputSlot<STACK, ITEM, CAP> slot, LabelAccess labelAccess) {
        ResourceType resourceType = slot.type;
        Object potential = slot.peekExtractPotential();
        if (resourceType.isEmpty(potential)) {
            return Optional.empty();
        }
        long toMove = resourceType.getAmount(potential);
        toMove = Long.min(toMove, slot.tracker.getResourceLimit().limit().quantity().number().value());
        long remainingObligation = slot.tracker.getRemainingRetentionObligation(resourceType, potential);
        toMove -= Long.min(toMove, remainingObligation);
        Object stack = potential = resourceType.withCount(potential, toMove);
        return SFMResourceTypes.DEFERRED_TYPES.getResourceKey(resourceType).map(x -> x).map(resourceTypeResourceKey -> SFMASTUtils.getInputStatementForStack(resourceTypeResourceKey, resourceType, stack, "temp", slot.slot, false, null)).map(inputStatement -> new InputStatement(new LabelAccess(labelAccess.labels(), labelAccess.directions(), inputStatement.labelAccess().slots(), RoundRobin.disabled()), inputStatement.resourceLimits(), inputStatement.each()));
    }

    public static <STACK, ITEM, CAP> InputStatement getInputStatementForStack(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeResourceKey, ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, String label, int slot, boolean each, @Nullable Direction direction) {
        LabelAccess labelAccess = new LabelAccess(List.of(new Label(label)), new DirectionQualifier(direction == null ? EnumSet.noneOf(Direction.class) : EnumSet.of(direction)), new NumberRangeSet(new NumberRange[]{new NumberRange(slot, slot)}), RoundRobin.disabled());
        Limit limit = new Limit(new ResourceQuantity(new Number(resourceType.getAmount(stack)), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), new ResourceQuantity(new Number(0L), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND));
        ResourceLocation stackId = resourceType.getRegistryKey(stack);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.location().getNamespace(), resourceTypeResourceKey.location().getPath(), stackId.getNamespace(), stackId.getPath());
        ResourceLimit resourceLimit = new ResourceLimit(new ResourceIdSet(List.of(resourceIdentifier)), limit, With.ALWAYS_TRUE);
        ResourceLimits resourceLimits = new ResourceLimits(List.of(resourceLimit), ResourceIdSet.EMPTY);
        return new InputStatement(labelAccess, resourceLimits, each);
    }
}

