/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class SharedQuantityExpandedRetentionInputResourceTracker
implements IInputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Long2ObjectOpenHashMap<Int2ObjectArrayMap<Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>>>> retention_obligations_by_pos_by_slot_by_item = new Long2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> retention_obligations_by_item = new Object2ObjectOpenHashMap();
    private long transferred = 0L;

    public SharedQuantityExpandedRetentionInputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long can_transfer = this.resource_limit.limit().quantity().number().value();
        return this.transferred >= can_transfer;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, ITEM, CAP> long getRetentionObligationForSlot(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, @NotStored BlockPos pos, int slot) {
        Object2ObjectOpenHashMap resourceTypeEntry;
        Int2ObjectArrayMap posEntry = (Int2ObjectArrayMap)this.retention_obligations_by_pos_by_slot_by_item.get(pos.asLong());
        if (posEntry != null && (resourceTypeEntry = (Object2ObjectOpenHashMap)posEntry.get(slot)) != null) {
            ResourceLocation item_id = resourceType.getRegistryKey(stack);
            Object2LongOpenHashMap itemEntry = (Object2LongOpenHashMap)resourceTypeEntry.get(resourceType);
            if (itemEntry != null) {
                return itemEntry.getLong((Object)item_id);
            }
        }
        return 0L;
    }

    @Override
    public <STACK, ITEM, CAP> long getRemainingRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        ResourceLocation item_id;
        long retention = this.resource_limit.limit().retention().number().value();
        long progress = 0L;
        Object2LongOpenHashMap entry = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(resourceType);
        if (entry != null && entry.containsKey((Object)(item_id = resourceType.getRegistryKey(stack)))) {
            progress = entry.getLong((Object)item_id);
        }
        return retention - progress;
    }

    @Override
    public <STACK, ITEM, CAP> void trackRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, int slot, @NotStored BlockPos pos, long promise) {
        ResourceLocation item_id = resourceType.getRegistryKey(stack);
        ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, promise);
        ((Object2LongOpenHashMap)((Object2ObjectOpenHashMap)((Int2ObjectArrayMap)this.retention_obligations_by_pos_by_slot_by_item.computeIfAbsent(pos.asLong(), k -> new Int2ObjectArrayMap())).computeIfAbsent(slot, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, promise);
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        long max = this.resource_limit.limit().quantity().number().value();
        return max - this.transferred;
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, long amount) {
        this.transferred += amount;
    }

    public String toString() {
        return "SharedQuantityExpandedRetentionInputResourceTracker@" + Integer.toHexString(System.identityHashCode(this)) + "{TRANSFERRED=" + this.transferred + ", RETENTION_OBLIGATION_PROGRESS=" + this.retention_obligations_by_item.values().stream().flatMapToLong(x -> x.values().longStream()).sum() + ", RESOURCE_LIMIT=" + String.valueOf(this.resource_limit) + ", EXCLUSIONS=" + String.valueOf(this.exclusions) + "}";
    }
}

