/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class ExpandedQuantitySharedRetentionInputResourceTracker
implements IInputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> transferred_by_item = new Object2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Int2LongArrayMap> retention_obligations_by_pos_by_slot = new Long2ObjectOpenHashMap();
    private long retention_obligation_progress = 0L;

    public ExpandedQuantitySharedRetentionInputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long can_transfer = this.resource_limit.limit().quantity().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(type);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = type.getRegistryKey(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        return transferred_for_item >= can_transfer;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, ITEM, CAP> long getRetentionObligationForSlot(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, @NotStored BlockPos pos, int slot) {
        Int2LongArrayMap posEntry = (Int2LongArrayMap)this.retention_obligations_by_pos_by_slot.get(pos.asLong());
        if (posEntry == null) {
            return 0L;
        }
        return posEntry.getOrDefault(slot, 0L);
    }

    @Override
    public <STACK, ITEM, CAP> long getRemainingRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        return this.resource_limit.limit().retention().number().value() - this.retention_obligation_progress;
    }

    @Override
    public <STACK, ITEM, CAP> void trackRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, int slot, @NotStored BlockPos pos, long promise) {
        this.retention_obligation_progress += promise;
        ((Int2LongArrayMap)this.retention_obligations_by_pos_by_slot.computeIfAbsent(pos.asLong(), k -> new Int2LongArrayMap())).merge(slot, promise, Long::sum);
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(resourceType);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = resourceType.getRegistryKey(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        return max_transfer - transferred_for_item;
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, long amount) {
        ResourceLocation item_id = resourceType.getRegistryKey(stack);
        ((Object2LongOpenHashMap)this.transferred_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, amount);
    }
}

