/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMASTUtils;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.With;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.antlr.v4.runtime.misc.Pair;

public record ServerboundOutputInspectionRequestPacket(String programString, int outputNodeIndex) implements SFMPacket
{
    private static final int MAX_RESULTS_LENGTH = 20480;

    public static String getOutputStatementInspectionResultsString(ManagerBlockEntity manager, Program successProgram, final OutputStatement outputStatement) {
        final StringBuilder payload = new StringBuilder();
        payload.append(outputStatement.toStringPretty()).append("\n");
        payload.append("-- predictions may differ from actual execution results\n");
        final AtomicInteger branchCount = new AtomicInteger(0);
        successProgram.replaceOutputStatement(outputStatement, new OutputStatement(outputStatement.labelAccess(), outputStatement.resourceLimits(), outputStatement.each()){

            @Override
            public void tick(ProgramContext context) {
                ProgramBehaviour programBehaviour = context.getBehaviour();
                if (!(programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour)) {
                    throw new IllegalStateException("Expected behaviour to be SimulateExploreAllPathsProgramBehaviour");
                }
                SimulateExploreAllPathsProgramBehaviour behaviour = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
                StringBuilder branchPayload = new StringBuilder();
                payload.append("-- POSSIBILITY ").append(branchCount.getAndIncrement()).append(" --");
                if (behaviour.getCurrentPath().streamBranches().allMatch(SimulateExploreAllPathsProgramBehaviour.Branch::wasTrue)) {
                    payload.append(" all true\n");
                } else if (behaviour.getCurrentPath().streamBranches().allMatch(Predicate.not(SimulateExploreAllPathsProgramBehaviour.Branch::wasTrue))) {
                    payload.append(" all false\n");
                } else {
                    payload.append('\n');
                }
                behaviour.getCurrentPath().streamBranches().forEach(branch -> {
                    if (branch.wasTrue()) {
                        payload.append(branch.ifStatement().condition().toStringPretty()).append(" -- true");
                    } else {
                        payload.append(branch.ifStatement().condition().toStringPretty()).append(" -- false");
                    }
                    payload.append("\n");
                });
                payload.append("\n");
                branchPayload.append("-- predicted inputs:\n");
                ArrayList inputSlots = new ArrayList();
                context.getInputs().forEach(inputStatement -> inputStatement.gatherSlots(context, (LimitedInputSlot<?, ?, ?> slot) -> inputSlots.add(new Pair(slot, (Object)inputStatement.labelAccess()))));
                List<InputStatement> inputStatements = inputSlots.stream().map(slot -> SFMASTUtils.getInputStatementForSlot((LimitedInputSlot)slot.a, (LabelAccess)slot.b)).filter(Optional::isPresent).map(Optional::get).toList();
                if (inputStatements.isEmpty()) {
                    branchPayload.append("none\n-- predicted outputs:\nnone");
                } else {
                    inputStatements.stream().map(InputStatement::toStringPretty).map(x -> x + "\n").forEach(branchPayload::append);
                    branchPayload.append("-- predicted outputs:\n");
                    ResourceLimits resourceLimits = new ResourceLimits(inputSlots.stream().map(slot -> (LimitedInputSlot)slot.a).map(ServerboundOutputInspectionRequestPacket::getSlotResource).toList(), ResourceIdSet.EMPTY);
                    ArrayList<ResourceLimit> condensedResourceLimitList = new ArrayList<ResourceLimit>();
                    for (ResourceLimit resourceLimit : resourceLimits.resourceLimitList()) {
                        condensedResourceLimitList.stream().filter(x -> x.resourceIds().equals(resourceLimit.resourceIds())).findFirst().ifPresentOrElse(found -> {
                            int i = condensedResourceLimitList.indexOf(found);
                            ResourceLimit newLimit = found.withLimit(new Limit(found.limit().quantity().add(resourceLimit.limit().quantity()), ResourceQuantity.MAX_QUANTITY));
                            condensedResourceLimitList.set(i, newLimit);
                        }, () -> condensedResourceLimitList.add(resourceLimit));
                    }
                    ListIterator<ResourceLimit> iter = condensedResourceLimitList.listIterator();
                    while (iter.hasNext()) {
                        ResourceLimit resourceLimit;
                        resourceLimit = (ResourceLimit)iter.next();
                        if (resourceLimit.resourceIds().size() != 1) {
                            throw new IllegalStateException("Expected resource limit to have exactly one resource id");
                        }
                        ResourceIdentifier resourceId = (ResourceIdentifier)resourceLimit.resourceIds().stream().iterator().next();
                        ResourceLocation resourceLimitLocation = ResourceLocation.fromNamespaceAndPath((String)resourceId.resourceNamespace, (String)resourceId.resourceName);
                        long accept = outputStatement.resourceLimits().resourceLimitList().stream().filter(outputResourceLimit -> outputResourceLimit.resourceIds().anyMatchResourceLocation(resourceLimitLocation) && outputStatement.resourceLimits().exclusions().stream().noneMatch(exclusion -> exclusion.matchesResourceLocation(resourceLimitLocation))).mapToLong(rl -> rl.limit().quantity().number().value()).max().orElse(0L);
                        if (accept == 0L) {
                            iter.remove();
                            continue;
                        }
                        iter.set(resourceLimit.withLimit(new Limit(new ResourceQuantity(new Number(Long.min(accept, resourceLimit.limit().quantity().number().value())), resourceLimit.limit().quantity().idExpansionBehaviour()), ResourceQuantity.MAX_QUANTITY)));
                    }
                    ResourceLimits condensedResourceLimits = new ResourceLimits(condensedResourceLimitList, ResourceIdSet.EMPTY);
                    if (condensedResourceLimits.resourceLimitList().isEmpty()) {
                        branchPayload.append("none\n");
                    } else {
                        branchPayload.append(new OutputStatement(outputStatement.labelAccess(), condensedResourceLimits, outputStatement.each()).toStringPretty());
                    }
                }
                branchPayload.append("\n");
                payload.append(branchPayload.toString().indent(4));
            }
        });
        successProgram.tick(new ProgramContext(successProgram, manager, new SimulateExploreAllPathsProgramBehaviour()));
        return payload.toString().strip();
    }

    private static <STACK, ITEM, CAP> ResourceLimit getSlotResource(LimitedInputSlot<STACK, ITEM, CAP> limitedInputSlot) {
        ResourceType resourceType = limitedInputSlot.type;
        ResourceKey resourceTypeResourceKey = SFMResourceTypes.DEFERRED_TYPES.getResourceKey(limitedInputSlot.type).map(x -> x).get();
        STACK stack = limitedInputSlot.peekExtractPotential();
        long amount = limitedInputSlot.type.getAmount(stack);
        amount = Long.min(amount, limitedInputSlot.tracker.getResourceLimit().limit().quantity().number().value());
        long remainingObligation = limitedInputSlot.tracker.getRemainingRetentionObligation(resourceType, stack);
        amount -= Long.min(amount, remainingObligation);
        Limit amountLimit = new Limit(new ResourceQuantity(new Number(amount), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), ResourceQuantity.MAX_QUANTITY);
        ResourceLocation stackId = resourceType.getRegistryKey(stack);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.location().getNamespace(), resourceTypeResourceKey.location().getPath(), stackId.getNamespace(), stackId.getPath());
        return new ResourceLimit(new ResourceIdSet(List.of(resourceIdentifier)), amountLimit, With.ALWAYS_TRUE);
    }

    public static class Daddy
    implements SFMPacketDaddy<ServerboundOutputInspectionRequestPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundOutputInspectionRequestPacket msg, RegistryFriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeUtf(msg.programString, 32367);
            friendlyByteBuf.writeInt(msg.outputNodeIndex());
        }

        @Override
        public ServerboundOutputInspectionRequestPacket decode(RegistryFriendlyByteBuf friendlyByteBuf) {
            return new ServerboundOutputInspectionRequestPacket(friendlyByteBuf.readUtf(32367), friendlyByteBuf.readInt());
        }

        @Override
        public void handle(ServerboundOutputInspectionRequestPacket msg, SFMPacketHandlingContext context) {
            context.compileAndThen(msg.programString, (program, player, managerBlockEntity) -> program.builder().getNodeAtIndex(msg.outputNodeIndex).filter(OutputStatement.class::isInstance).map(OutputStatement.class::cast).ifPresent(outputStatement -> {
                String payload = ServerboundOutputInspectionRequestPacket.getOutputStatementInspectionResultsString(managerBlockEntity, program, outputStatement);
                payload = SFMPacketDaddy.truncate(payload, 20480);
                SFM.LOGGER.debug("Sending output inspection results packet with length {}", (Object)payload.length());
                SFMPackets.sendToPlayer(() -> player, (SFMPacket)new ClientboundOutputInspectionResultsPacket(payload));
            }));
        }

        @Override
        public Class<ServerboundOutputInspectionRequestPacket> getPacketClass() {
            return ServerboundOutputInspectionRequestPacket.class;
        }
    }
}

