/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMASTUtils;
import ca.teamdman.sfml.ast.InputStatement;
import net.minecraft.network.RegistryFriendlyByteBuf;

public record ServerboundInputInspectionRequestPacket(String programString, int inputNodeIndex) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundInputInspectionRequestPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundInputInspectionRequestPacket msg, RegistryFriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeUtf(msg.programString, 32367);
            friendlyByteBuf.writeInt(msg.inputNodeIndex());
        }

        @Override
        public ServerboundInputInspectionRequestPacket decode(RegistryFriendlyByteBuf friendlyByteBuf) {
            return new ServerboundInputInspectionRequestPacket(friendlyByteBuf.readUtf(32367), friendlyByteBuf.readInt());
        }

        @Override
        public void handle(ServerboundInputInspectionRequestPacket msg, SFMPacketHandlingContext context) {
            context.compileAndThen(msg.programString, (program, player, managerBlockEntity) -> program.builder().getNodeAtIndex(msg.inputNodeIndex).filter(InputStatement.class::isInstance).map(InputStatement.class::cast).ifPresent(inputStatement -> {
                StringBuilder payload = new StringBuilder();
                payload.append(inputStatement.toStringPretty()).append("\n-- peek results --\n");
                ProgramContext programContext = new ProgramContext(program, managerBlockEntity, new SimulateExploreAllPathsProgramBehaviour());
                int preLen = payload.length();
                inputStatement.gatherSlots(programContext, slot -> SFMASTUtils.getInputStatementForSlot(slot, inputStatement.labelAccess()).ifPresent(is -> payload.append(is.toStringPretty()).append("\n")));
                if (payload.length() == preLen) {
                    payload.append("none");
                }
                SFMPackets.sendToPlayer(() -> player, (SFMPacket)new ClientboundInputInspectionResultsPacket(SFMPacketDaddy.truncate(payload.toString(), 20480)));
            }));
        }

        @Override
        public Class<ServerboundInputInspectionRequestPacket> getPacketClass() {
            return ServerboundInputInspectionRequestPacket.class;
        }
    }
}

