/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.ClientScreenHelpers;
import ca.teamdman.sfm.client.handler.LabelGunKeyMappingHandler;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LabelGunItem
extends Item {
    public LabelGunItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static void setActiveLabel(ItemStack stack, @Nullable String label) {
        if (label == null || label.isEmpty()) {
            LabelGunItem.clearActiveLabel(stack);
        } else {
            LabelPositionHolder.from(stack).addReferencedLabel(label).save(stack);
            stack.set(SFMDataComponents.ACTIVE_LABEL, (Object)label);
        }
    }

    public static String getActiveLabel(ItemStack stack) {
        return (String)stack.getOrDefault(SFMDataComponents.ACTIVE_LABEL, (Object)"");
    }

    public static String getNextLabel(ItemStack gun, int change) {
        List labels = LabelPositionHolder.from(gun).labels().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        if (labels.isEmpty()) {
            return "";
        }
        String currentLabel = LabelGunItem.getActiveLabel(gun);
        int currentLabelIndex = 0;
        for (int i = 0; i < labels.size(); ++i) {
            if (!((String)labels.get(i)).equals(currentLabel)) continue;
            currentLabelIndex = i;
            break;
        }
        int nextLabelIndex = currentLabelIndex + change;
        nextLabelIndex = (nextLabelIndex % labels.size() + labels.size()) % labels.size();
        return (String)labels.get(nextLabelIndex);
    }

    public static void clearActiveLabel(ItemStack gun) {
        gun.remove(SFMDataComponents.ACTIVE_LABEL);
    }

    public static LabelGunViewMode getViewMode(ItemStack stack) {
        return (LabelGunViewMode)((Object)stack.getOrDefault(SFMDataComponents.LABEL_GUN_VIEW_MODE, (Object)LabelGunViewMode.SHOW_ALL));
    }

    public static void setViewMode(ItemStack stack, LabelGunViewMode mode) {
        stack.set(SFMDataComponents.LABEL_GUN_VIEW_MODE, (Object)mode);
    }

    public static void cycleViewMode(ItemStack stack) {
        LabelGunViewMode current = LabelGunItem.getViewMode(stack);
        int nextOrdinal = (current.ordinal() + 1) % LabelGunViewMode.values().length;
        LabelGunItem.setViewMode(stack, LabelGunViewMode.values()[nextOrdinal]);
    }

    public InteractionResult onItemUseFirst(ItemStack gun, UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (level.isClientSide && ctx.getPlayer() != null) {
            boolean pickBlock = ClientKeyHelpers.isKeyDownInWorld(SFMKeyMappings.LABEL_GUN_PICK_BLOCK_MODIFIER_KEY);
            SFMPackets.sendToServer(new ServerboundLabelGunUsePacket(ctx.getHand(), ctx.getClickedPos(), Screen.hasControlDown(), pickBlock, ctx.getPlayer().isShiftKeyDown()));
            if (pickBlock) {
                LabelGunKeyMappingHandler.setExternalDebounce();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> lines, TooltipFlag pTooltipFlag) {
        if (SFMItemUtils.isClientAndMoreInfoKeyPressed()) {
            Options options = Minecraft.getInstance().options;
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_1.getComponent(options.keyUse.getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_2.getComponent(options.keyUse.getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_3.getComponent(Component.literal((String)"Control").withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_4.getComponent(options.keyPickItem.getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            lines.add((Component)LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_5.getComponent(((KeyMapping)SFMKeyMappings.CYCLE_LABEL_VIEW_KEY.get()).getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
        } else {
            SFMItemUtils.appendMoreInfoKeyReminderTextIfOnClient(lines);
        }
        lines.addAll(LabelPositionHolder.from(stack).asHoverText());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            ClientScreenHelpers.showLabelGunScreen(stack, hand);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public Component getName(ItemStack stack) {
        String name = LabelGunItem.getActiveLabel(stack);
        if (name.isEmpty()) {
            return super.getName(stack);
        }
        return LocalizationKeys.LABEL_GUN_ITEM_NAME_WITH_LABEL.getComponent(name).withStyle(ChatFormatting.AQUA);
    }

    public static void clearAll(ItemStack stack) {
        LabelPositionHolder.clear(stack);
        LabelGunItem.setActiveLabel(stack, null);
    }

    public static enum LabelGunViewMode implements StringRepresentable
    {
        SHOW_ALL,
        SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK,
        SHOW_ONLY_TARGETED_BLOCK;

        public static final Codec<LabelGunViewMode> CODEC;
        public static final IntFunction<LabelGunViewMode> BY_ID;
        public static final StreamCodec<ByteBuf, LabelGunViewMode> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LabelGunViewMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])LabelGunViewMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

