/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ModConfigSpec SERVER_SPEC;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final SFMServerConfig SERVER;
    public static final SFMClientConfig CLIENT;

    public static <T> T getOrDefault(ModConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair serverSpecPair = new ModConfigSpec.Builder().configure(SFMServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)serverSpecPair.getRight();
        SERVER = (SFMServerConfig)serverSpecPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(SFMClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (SFMClientConfig)clientSpecPair.getLeft();
    }

    @EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.MOD)
    public static class SFMServerConfig {
        public final ModConfigSpec.BooleanValue disableProgramExecution;
        public final ModConfigSpec.BooleanValue logResourceLossToConsole;
        public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicks;
        public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO;
        public final ModConfigSpec.IntValue maxIfStatementsInTriggerBeforeSimulationIsntAllowed;
        public final ModConfigSpec.ConfigValue<List<? extends String>> disallowedResourceTypesForTransfer;
        public final ModConfigSpec.EnumValue<LevelsToShards> levelsToShards;
        private int revision = 0;

        SFMServerConfig(ModConfigSpec.Builder builder) {
            builder.comment("This config is shown to clients, don't put anything secret in here");
            this.disableProgramExecution = builder.comment("Prevents factory managers from compiling and running code (for emergencies)").define("disableProgramExecution", false);
            this.logResourceLossToConsole = builder.comment("Log resource loss to console").define("logResourceLossToConsole", true);
            this.timerTriggerMinimumIntervalInTicks = builder.defineInRange("timerTriggerMinimumIntervalInTicks", 20, 1, Integer.MAX_VALUE);
            this.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO = builder.defineInRange("timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIOStatementsPresent", 1, 1, Integer.MAX_VALUE);
            this.maxIfStatementsInTriggerBeforeSimulationIsntAllowed = builder.comment("The number of scenarios to check is 2^n where n is the number of if statements in a trigger").defineInRange("maxIfStatementsInTriggerBeforeSimulationIsntAllowed", 10, 0, Integer.MAX_VALUE);
            this.disallowedResourceTypesForTransfer = builder.comment("What resource types should SFM not be allowed to move").defineListAllowEmpty(List.of("disallowedResourceTypesForTransfer"), List::of, String.class::isInstance);
            this.levelsToShards = builder.comment(new String[]{"How to convert Enchanted Books to Experience Shards", "JustOne = always produces 1 shard regardless of enchantments", "EachOne = produces 1 shard per enchantment on the book.", "SumLevels = produces a number of shards equal to the sum of the enchantments' levels", "SumLevelsScaledExponentially = produces a number of shards equal to the sum of 2 to the power of each enchantment's level (1 -> 1 shard, 2 -> 4 shards, 3 -> 8 shards, etc)"}).defineEnum("levelsToShards", (Enum)LevelsToShards.JustOne);
        }

        public int getRevision() {
            return this.revision;
        }

        @SubscribeEvent
        public static void onConfigLoaded(ModConfigEvent.Loading event) {
            if (event.getConfig().getSpec() == SERVER_SPEC) {
                ++SFMConfig.SERVER.revision;
                SFM.LOGGER.info("SFM config loaded, now on revision {}", (Object)SFMConfig.SERVER.revision);
            }
        }

        @SubscribeEvent
        public static void onConfigReloaded(ModConfigEvent.Reloading event) {
            if (event.getConfig().getSpec() == SERVER_SPEC) {
                ++SFMConfig.SERVER.revision;
                SFM.LOGGER.info("SFM config reloaded, now on revision {}", (Object)SFMConfig.SERVER.revision);
            }
        }

        public static enum LevelsToShards {
            JustOne,
            EachOne,
            SumLevels,
            SumLevelsScaledExponentially;

        }
    }

    public static class SFMClientConfig {
        public final ModConfigSpec.BooleanValue showLineNumbers;
        public final ModConfigSpec.BooleanValue showLabelGunReminderOverlay;
        public final ModConfigSpec.BooleanValue showNetworkToolReminderOverlay;

        SFMClientConfig(ModConfigSpec.Builder builder) {
            this.showLineNumbers = builder.define("showLineNumbers", false);
            this.showLabelGunReminderOverlay = builder.define("showLabelGunReminderOverlay", true);
            this.showNetworkToolReminderOverlay = builder.define("showNetworkToolReminderOverlay", true);
        }
    }
}

