/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LabelGunReminderOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalizationEntry msg;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        LabelGunItem.LabelGunViewMode viewMode = LabelGunReminderOverlay.getViewMode(minecraft);
        if (viewMode == null) {
            return;
        }
        switch (viewMode) {
            default: {
                throw new MatchException(null, null);
            }
            case SHOW_ALL: {
                LocalizationEntry localizationEntry = null;
                break;
            }
            case SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK: {
                LocalizationEntry localizationEntry = LocalizationKeys.LABEL_GUN_VIEW_MODE_SHOW_ONLY_ACTIVE_AND_TARGETED;
                break;
            }
            case SHOW_ONLY_TARGETED_BLOCK: {
                LocalizationEntry localizationEntry = msg = LocalizationKeys.LABEL_GUN_VIEW_MODE_SHOW_ONLY_TARGETED;
            }
        }
        if (msg == null) {
            return;
        }
        Font font = minecraft.font;
        MutableComponent reminder = msg.getComponent(((KeyMapping)SFMKeyMappings.CYCLE_LABEL_VIEW_KEY.get()).getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.YELLOW));
        int reminderWidth = font.width((FormattedText)reminder);
        int x = guiGraphics.guiWidth() / 2 - reminderWidth / 2;
        int y = 20;
        guiGraphics.drawString(font, (Component)reminder, x, y, FastColor.ARGB32.color((int)255, (int)172, (int)208, (int)255));
    }

    @Nullable
    private static LabelGunItem.LabelGunViewMode getViewMode(Minecraft minecraft) {
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return null;
        }
        if (!((Boolean)SFMConfig.CLIENT.showLabelGunReminderOverlay.get()).booleanValue()) {
            return null;
        }
        ItemStack labelGun = SFMHandUtils.getItemInEitherHand((Player)player, SFMItems.LABEL_GUN_ITEM.get());
        if (labelGun.isEmpty()) {
            return null;
        }
        return LabelGunItem.getViewMode(labelGun);
    }
}

