/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;

public class LimitedPillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> CENTER = List.of(AthenaQuad.withSprite(2));
    private static final List<AthenaQuad> TOP = List.of(AthenaQuad.withSprite(1));
    private static final List<AthenaQuad> BOTTOM = List.of(AthenaQuad.withSprite(3));
    private static final List<AthenaQuad> SELF = List.of(AthenaQuad.withSprite(4));
    private static final List<AthenaQuad> CAP = List.of(AthenaQuad.withSprite(0));
    private final Int2ObjectMap<Material> materials;

    public LimitedPillarBlockModel(Int2ObjectMap<Material> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        boolean max;
        BlockPos occludingPos = pos.relative(direction);
        BlockState appearance = level.getAppearance(state, pos, direction, level.getBlockState(occludingPos), occludingPos);
        BlockState occludingAppearance = level.getAppearance(occludingPos, direction.getOpposite(), state, pos);
        if (!appearance.isAir() && occludingAppearance.is(appearance.getBlock())) {
            return List.of();
        }
        if (direction.getAxis().isVertical()) {
            return CAP;
        }
        BlockPos posAbove = pos.above();
        BlockPos posBelow = pos.below();
        BlockState appearanceAbove = level.getAppearance(state, pos, direction, level.getBlockState(posAbove), posAbove);
        BlockState appearanceBelow = level.getAppearance(state, pos, direction, level.getBlockState(posBelow), posBelow);
        boolean min = !appearanceAbove.isAir() && level.getAppearance(posAbove, direction, state, pos).is(appearanceAbove.getBlock());
        boolean bl = max = !appearanceBelow.isAir() && level.getAppearance(posBelow, direction, state, pos).is(appearanceBelow.getBlock());
        if (min && max) {
            return CENTER;
        }
        if (min) {
            return BOTTOM;
        }
        if (max) {
            return TOP;
        }
        return SELF;
    }

    @Override
    public Map<Direction, List<AthenaQuad>> getDefaultQuads(Direction direction) {
        HashMap<Direction, List<AthenaQuad>> quads = new HashMap<Direction, List<AthenaQuad>>(Direction.values().length);
        for (Direction dir : Direction.values()) {
            quads.put(dir, SELF);
        }
        return quads;
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((Material)entry.getValue()));
        }
        return textures;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<Material> materials = Factory.parseMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"));
            return () -> new LimitedPillarBlockModel(materials);
        }

        private static Int2ObjectMap<Material> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"bottom")));
            return materials;
        }
    }
}

